@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property alignment If no explicit xPosition or yPosition is provided, setting alignment to centered will place the captions at the bottom center of the output. Similarly, setting a left alignment will align captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified (either left or centered) relative to those coordinates. Selecting “smart” justification will left-justify live subtitles and center-justify pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.
 * @property backgroundColor Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must match.
 * @property backgroundOpacity Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent. Leaving this parameter out is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
 * @property font External font file used for caption burn-in. File extension must be ‘ttf’ or ‘tte’. Although the user can select output fonts for many different types of input captions, embedded, STL and teletext sources use a strict grid system. Using external fonts with these caption sources could cause unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match. See Font for more details.
 * @property fontColor Specifies the color of the burned-in captions. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.
 * @property fontOpacity Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.
 * @property fontResolution Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and DVB-Sub font settings must match.
 * @property fontSize When set to ‘auto’ fontSize will scale depending on the size of the output. Giving a positive integer will specify the exact font size in points. All burn-in and DVB-Sub font settings must match.
 * @property outlineColor Specifies font outline color. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.
 * @property outlineSize Specifies font outline size in pixels. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.
 * @property shadowColor Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub font settings must match.
 * @property shadowOpacity Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving this parameter out is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
 * @property shadowXOffset Specifies the horizontal offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
 * @property shadowYOffset Specifies the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
 * @property teletextGridControl Controls whether a fixed grid size will be used to generate the output subtitles bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
 * @property xPosition Specifies the horizontal position of the caption relative to the left side of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal caption position will be determined by the alignment parameter. All burn-in and DVB-Sub font settings must match.
 * @property yPosition Specifies the vertical position of the caption relative to the top of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the caption will be positioned towards the bottom of the output. All burn-in and DVB-Sub font settings must match.
 */
public data class
ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsArgs(
    public val alignment: Output<String>? = null,
    public val backgroundColor: Output<String>? = null,
    public val backgroundOpacity: Output<Int>? = null,
    public val font:
    Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsFontArgs>? =
        null,
    public val fontColor: Output<String>? = null,
    public val fontOpacity: Output<Int>? = null,
    public val fontResolution: Output<Int>? = null,
    public val fontSize: Output<String>? = null,
    public val outlineColor: Output<String>,
    public val outlineSize: Output<Int>? = null,
    public val shadowColor: Output<String>? = null,
    public val shadowOpacity: Output<Int>? = null,
    public val shadowXOffset: Output<Int>? = null,
    public val shadowYOffset: Output<Int>? = null,
    public val teletextGridControl: Output<String>,
    public val xPosition: Output<Int>? = null,
    public val yPosition: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsArgs.builder()
            .alignment(alignment?.applyValue({ args0 -> args0 }))
            .backgroundColor(backgroundColor?.applyValue({ args0 -> args0 }))
            .backgroundOpacity(backgroundOpacity?.applyValue({ args0 -> args0 }))
            .font(font?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fontColor(fontColor?.applyValue({ args0 -> args0 }))
            .fontOpacity(fontOpacity?.applyValue({ args0 -> args0 }))
            .fontResolution(fontResolution?.applyValue({ args0 -> args0 }))
            .fontSize(fontSize?.applyValue({ args0 -> args0 }))
            .outlineColor(outlineColor.applyValue({ args0 -> args0 }))
            .outlineSize(outlineSize?.applyValue({ args0 -> args0 }))
            .shadowColor(shadowColor?.applyValue({ args0 -> args0 }))
            .shadowOpacity(shadowOpacity?.applyValue({ args0 -> args0 }))
            .shadowXOffset(shadowXOffset?.applyValue({ args0 -> args0 }))
            .shadowYOffset(shadowYOffset?.applyValue({ args0 -> args0 }))
            .teletextGridControl(teletextGridControl.applyValue({ args0 -> args0 }))
            .xPosition(xPosition?.applyValue({ args0 -> args0 }))
            .yPosition(yPosition?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsArgsBuilder
internal constructor() {
    private var alignment: Output<String>? = null

    private var backgroundColor: Output<String>? = null

    private var backgroundOpacity: Output<Int>? = null

    private var font:
        Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsFontArgs>? =
        null

    private var fontColor: Output<String>? = null

    private var fontOpacity: Output<Int>? = null

    private var fontResolution: Output<Int>? = null

    private var fontSize: Output<String>? = null

    private var outlineColor: Output<String>? = null

    private var outlineSize: Output<Int>? = null

    private var shadowColor: Output<String>? = null

    private var shadowOpacity: Output<Int>? = null

    private var shadowXOffset: Output<Int>? = null

    private var shadowYOffset: Output<Int>? = null

    private var teletextGridControl: Output<String>? = null

    private var xPosition: Output<Int>? = null

    private var yPosition: Output<Int>? = null

    /**
     * @param value If no explicit xPosition or yPosition is provided, setting alignment to centered will place the captions at the bottom center of the output. Similarly, setting a left alignment will align captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified (either left or centered) relative to those coordinates. Selecting “smart” justification will left-justify live subtitles and center-justify pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("jhusywpobbbmjraj")
    public suspend fun alignment(`value`: Output<String>) {
        this.alignment = value
    }

    /**
     * @param value Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("eocvbktbrlafyksl")
    public suspend fun backgroundColor(`value`: Output<String>) {
        this.backgroundColor = value
    }

    /**
     * @param value Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent. Leaving this parameter out is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("flekjjlvgwhefgpg")
    public suspend fun backgroundOpacity(`value`: Output<Int>) {
        this.backgroundOpacity = value
    }

    /**
     * @param value External font file used for caption burn-in. File extension must be ‘ttf’ or ‘tte’. Although the user can select output fonts for many different types of input captions, embedded, STL and teletext sources use a strict grid system. Using external fonts with these caption sources could cause unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match. See Font for more details.
     */
    @JvmName("fkgjlcffgcrjktvh")
    public suspend
    fun font(`value`: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsFontArgs>) {
        this.font = value
    }

    /**
     * @param value Specifies the color of the burned-in captions. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("gijqpcnrbkxidkme")
    public suspend fun fontColor(`value`: Output<String>) {
        this.fontColor = value
    }

    /**
     * @param value Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("jrxaghobmygdnfii")
    public suspend fun fontOpacity(`value`: Output<Int>) {
        this.fontOpacity = value
    }

    /**
     * @param value Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("dvumdsivbgaqjgrt")
    public suspend fun fontResolution(`value`: Output<Int>) {
        this.fontResolution = value
    }

    /**
     * @param value When set to ‘auto’ fontSize will scale depending on the size of the output. Giving a positive integer will specify the exact font size in points. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("sovrbsuhntbuhhxd")
    public suspend fun fontSize(`value`: Output<String>) {
        this.fontSize = value
    }

    /**
     * @param value Specifies font outline color. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("xghyhuxjjcmaawxp")
    public suspend fun outlineColor(`value`: Output<String>) {
        this.outlineColor = value
    }

    /**
     * @param value Specifies font outline size in pixels. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("dtcktxanygotuqgi")
    public suspend fun outlineSize(`value`: Output<Int>) {
        this.outlineSize = value
    }

    /**
     * @param value Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("yjuqspgdxikywaru")
    public suspend fun shadowColor(`value`: Output<String>) {
        this.shadowColor = value
    }

    /**
     * @param value Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving this parameter out is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("wxbykqrkkaxbovra")
    public suspend fun shadowOpacity(`value`: Output<Int>) {
        this.shadowOpacity = value
    }

    /**
     * @param value Specifies the horizontal offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("readbgascbnngusw")
    public suspend fun shadowXOffset(`value`: Output<Int>) {
        this.shadowXOffset = value
    }

    /**
     * @param value Specifies the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("bypcidualksraphe")
    public suspend fun shadowYOffset(`value`: Output<Int>) {
        this.shadowYOffset = value
    }

    /**
     * @param value Controls whether a fixed grid size will be used to generate the output subtitles bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
     */
    @JvmName("othxyneeurqwuvgl")
    public suspend fun teletextGridControl(`value`: Output<String>) {
        this.teletextGridControl = value
    }

    /**
     * @param value Specifies the horizontal position of the caption relative to the left side of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal caption position will be determined by the alignment parameter. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("dokffumlnwmcedxh")
    public suspend fun xPosition(`value`: Output<Int>) {
        this.xPosition = value
    }

    /**
     * @param value Specifies the vertical position of the caption relative to the top of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the caption will be positioned towards the bottom of the output. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("bqaoxdpnsxyppahc")
    public suspend fun yPosition(`value`: Output<Int>) {
        this.yPosition = value
    }

    /**
     * @param value If no explicit xPosition or yPosition is provided, setting alignment to centered will place the captions at the bottom center of the output. Similarly, setting a left alignment will align captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified (either left or centered) relative to those coordinates. Selecting “smart” justification will left-justify live subtitles and center-justify pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("ovhmihqrrdpbndei")
    public suspend fun alignment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alignment = mapped
    }

    /**
     * @param value Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("obniegstdhklpwjs")
    public suspend fun backgroundColor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backgroundColor = mapped
    }

    /**
     * @param value Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent. Leaving this parameter out is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("chnujkufnadedgep")
    public suspend fun backgroundOpacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backgroundOpacity = mapped
    }

    /**
     * @param value External font file used for caption burn-in. File extension must be ‘ttf’ or ‘tte’. Although the user can select output fonts for many different types of input captions, embedded, STL and teletext sources use a strict grid system. Using external fonts with these caption sources could cause unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match. See Font for more details.
     */
    @JvmName("insbedriuasoesac")
    public suspend
    fun font(`value`: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsFontArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.font = mapped
    }

    /**
     * @param argument External font file used for caption burn-in. File extension must be ‘ttf’ or ‘tte’. Although the user can select output fonts for many different types of input captions, embedded, STL and teletext sources use a strict grid system. Using external fonts with these caption sources could cause unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match. See Font for more details.
     */
    @JvmName("cqmvbruiwtjeigmy")
    public suspend
    fun font(argument: suspend ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsFontArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsFontArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.font = mapped
    }

    /**
     * @param value Specifies the color of the burned-in captions. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("xpthaffopjjfkath")
    public suspend fun fontColor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fontColor = mapped
    }

    /**
     * @param value Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("qirlyvdwgeajyjlx")
    public suspend fun fontOpacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fontOpacity = mapped
    }

    /**
     * @param value Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("fdgjbnidrlwryqpf")
    public suspend fun fontResolution(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fontResolution = mapped
    }

    /**
     * @param value When set to ‘auto’ fontSize will scale depending on the size of the output. Giving a positive integer will specify the exact font size in points. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("tlhrfxeabajoivkp")
    public suspend fun fontSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fontSize = mapped
    }

    /**
     * @param value Specifies font outline color. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("xuumnaflldaxvrml")
    public suspend fun outlineColor(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outlineColor = mapped
    }

    /**
     * @param value Specifies font outline size in pixels. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("xrduuwnqaljdvlll")
    public suspend fun outlineSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outlineSize = mapped
    }

    /**
     * @param value Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("vfmfjptrsfjxjxfw")
    public suspend fun shadowColor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shadowColor = mapped
    }

    /**
     * @param value Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving this parameter out is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("elvogprxkthckmev")
    public suspend fun shadowOpacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shadowOpacity = mapped
    }

    /**
     * @param value Specifies the horizontal offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("skvuiennagrjisyj")
    public suspend fun shadowXOffset(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shadowXOffset = mapped
    }

    /**
     * @param value Specifies the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("wmleaglkwtxhccsu")
    public suspend fun shadowYOffset(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shadowYOffset = mapped
    }

    /**
     * @param value Controls whether a fixed grid size will be used to generate the output subtitles bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
     */
    @JvmName("dpwoglbgwrofaqyn")
    public suspend fun teletextGridControl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.teletextGridControl = mapped
    }

    /**
     * @param value Specifies the horizontal position of the caption relative to the left side of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal caption position will be determined by the alignment parameter. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("pmrkdemybtvibugm")
    public suspend fun xPosition(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xPosition = mapped
    }

    /**
     * @param value Specifies the vertical position of the caption relative to the top of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the caption will be positioned towards the bottom of the output. All burn-in and DVB-Sub font settings must match.
     */
    @JvmName("mclpdbfhifrpafly")
    public suspend fun yPosition(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.yPosition = mapped
    }

    internal fun build():
        ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsArgs =
        ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsArgs(
            alignment = alignment,
            backgroundColor = backgroundColor,
            backgroundOpacity = backgroundOpacity,
            font = font,
            fontColor = fontColor,
            fontOpacity = fontOpacity,
            fontResolution = fontResolution,
            fontSize = fontSize,
            outlineColor = outlineColor ?: throw PulumiNullFieldException("outlineColor"),
            outlineSize = outlineSize,
            shadowColor = shadowColor,
            shadowOpacity = shadowOpacity,
            shadowXOffset = shadowXOffset,
            shadowYOffset = shadowYOffset,
            teletextGridControl = teletextGridControl ?: throw PulumiNullFieldException("teletextGridControl"),
            xPosition = xPosition,
            yPosition = yPosition,
        )
}
