@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsMotionGraphicsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property motionGraphicsInsertion Motion Graphics Insertion.
 * @property motionGraphicsSettings Motion Graphics Settings. See Motion Graphics Settings for more details.
 */
public data class ChannelEncoderSettingsMotionGraphicsConfigurationArgs(
    public val motionGraphicsInsertion: Output<String>? = null,
    public val motionGraphicsSettings:
    Output<ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsMotionGraphicsConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsMotionGraphicsConfigurationArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsMotionGraphicsConfigurationArgs.builder()
            .motionGraphicsInsertion(motionGraphicsInsertion?.applyValue({ args0 -> args0 }))
            .motionGraphicsSettings(
                motionGraphicsSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelEncoderSettingsMotionGraphicsConfigurationArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsMotionGraphicsConfigurationArgsBuilder internal constructor() {
    private var motionGraphicsInsertion: Output<String>? = null

    private var motionGraphicsSettings:
        Output<ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsArgs>? = null

    /**
     * @param value Motion Graphics Insertion.
     */
    @JvmName("riqoekktorpoagxo")
    public suspend fun motionGraphicsInsertion(`value`: Output<String>) {
        this.motionGraphicsInsertion = value
    }

    /**
     * @param value Motion Graphics Settings. See Motion Graphics Settings for more details.
     */
    @JvmName("nerrsiymtowhxhnn")
    public suspend
    fun motionGraphicsSettings(`value`: Output<ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsArgs>) {
        this.motionGraphicsSettings = value
    }

    /**
     * @param value Motion Graphics Insertion.
     */
    @JvmName("aiwmywkdfkuikeer")
    public suspend fun motionGraphicsInsertion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.motionGraphicsInsertion = mapped
    }

    /**
     * @param value Motion Graphics Settings. See Motion Graphics Settings for more details.
     */
    @JvmName("yaqqnynuwtqiissr")
    public suspend
    fun motionGraphicsSettings(`value`: ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.motionGraphicsSettings = mapped
    }

    /**
     * @param argument Motion Graphics Settings. See Motion Graphics Settings for more details.
     */
    @JvmName("osrdhsxiarihrgii")
    public suspend
    fun motionGraphicsSettings(argument: suspend ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsMotionGraphicsConfigurationMotionGraphicsSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.motionGraphicsSettings = mapped
    }

    internal fun build(): ChannelEncoderSettingsMotionGraphicsConfigurationArgs =
        ChannelEncoderSettingsMotionGraphicsConfigurationArgs(
            motionGraphicsInsertion = motionGraphicsInsertion,
            motionGraphicsSettings = motionGraphicsSettings ?: throw
                PulumiNullFieldException("motionGraphicsSettings"),
        )
}
