@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Custom output group name defined by the user.
 * @property outputGroupSettings Settings associated with the output group. See Output Group Settings for more details.
 * @property outputs List of outputs. See Outputs for more details.
 */
public data class ChannelEncoderSettingsOutputGroupArgs(
    public val name: Output<String>? = null,
    public val outputGroupSettings: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs>,
    public val outputs: Output<List<ChannelEncoderSettingsOutputGroupOutputArgs>>,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .outputGroupSettings(
                outputGroupSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .outputs(
                outputs.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsOutputGroupArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var outputGroupSettings: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs>? =
        null

    private var outputs: Output<List<ChannelEncoderSettingsOutputGroupOutputArgs>>? = null

    /**
     * @param value Custom output group name defined by the user.
     */
    @JvmName("qutracvwmhiemvyr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Settings associated with the output group. See Output Group Settings for more details.
     */
    @JvmName("jrgliygtvayhpwvn")
    public suspend
    fun outputGroupSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs>) {
        this.outputGroupSettings = value
    }

    /**
     * @param value List of outputs. See Outputs for more details.
     */
    @JvmName("krympaoajdcnitbh")
    public suspend fun outputs(`value`: Output<List<ChannelEncoderSettingsOutputGroupOutputArgs>>) {
        this.outputs = value
    }

    @JvmName("ujubqrhyespefxtv")
    public suspend fun outputs(vararg values: Output<ChannelEncoderSettingsOutputGroupOutputArgs>) {
        this.outputs = Output.all(values.asList())
    }

    /**
     * @param values List of outputs. See Outputs for more details.
     */
    @JvmName("bumiaxiomulpalnn")
    public suspend fun outputs(values: List<Output<ChannelEncoderSettingsOutputGroupOutputArgs>>) {
        this.outputs = Output.all(values)
    }

    /**
     * @param value Custom output group name defined by the user.
     */
    @JvmName("hatyljpewguvdfsy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Settings associated with the output group. See Output Group Settings for more details.
     */
    @JvmName("djmpfufanltblyar")
    public suspend
    fun outputGroupSettings(`value`: ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputGroupSettings = mapped
    }

    /**
     * @param argument Settings associated with the output group. See Output Group Settings for more details.
     */
    @JvmName("xfpuayixcbueftnn")
    public suspend
    fun outputGroupSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.outputGroupSettings = mapped
    }

    /**
     * @param value List of outputs. See Outputs for more details.
     */
    @JvmName("afeaonclgidajspl")
    public suspend fun outputs(`value`: List<ChannelEncoderSettingsOutputGroupOutputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param argument List of outputs. See Outputs for more details.
     */
    @JvmName("vegceidpyqxxgmah")
    public suspend
    fun outputs(argument: List<suspend ChannelEncoderSettingsOutputGroupOutputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsOutputGroupOutputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument List of outputs. See Outputs for more details.
     */
    @JvmName("vcafxnccjcjyepjq")
    public suspend fun outputs(
        vararg
        argument: suspend ChannelEncoderSettingsOutputGroupOutputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsOutputGroupOutputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument List of outputs. See Outputs for more details.
     */
    @JvmName("uswtbgkeidlfusmi")
    public suspend
    fun outputs(argument: suspend ChannelEncoderSettingsOutputGroupOutputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ChannelEncoderSettingsOutputGroupOutputArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param values List of outputs. See Outputs for more details.
     */
    @JvmName("mwekledbmgydpybw")
    public suspend fun outputs(vararg values: ChannelEncoderSettingsOutputGroupOutputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupArgs =
        ChannelEncoderSettingsOutputGroupArgs(
            name = name,
            outputGroupSettings = outputGroupSettings ?: throw PulumiNullFieldException("outputGroupSettings"),
            outputs = outputs ?: throw PulumiNullFieldException("outputs"),
        )
}
