@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property audioDescriptionNames The names of the audio descriptions used as audio sources for the output.
 * @property captionDescriptionNames The names of the caption descriptions used as caption sources for the output.
 * @property outputName The name used to identify an output.
 * @property outputSettings Settings for output. See Output Settings for more details.
 * @property videoDescriptionName The name of the video description used as video source for the output.
 */
public data class ChannelEncoderSettingsOutputGroupOutputArgs(
    public val audioDescriptionNames: Output<List<String>>? = null,
    public val captionDescriptionNames: Output<List<String>>? = null,
    public val outputName: Output<String>? = null,
    public val outputSettings: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs>,
    public val videoDescriptionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputArgs.builder()
            .audioDescriptionNames(audioDescriptionNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .captionDescriptionNames(
                captionDescriptionNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .outputName(outputName?.applyValue({ args0 -> args0 }))
            .outputSettings(outputSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .videoDescriptionName(videoDescriptionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsOutputGroupOutputArgsBuilder internal constructor() {
    private var audioDescriptionNames: Output<List<String>>? = null

    private var captionDescriptionNames: Output<List<String>>? = null

    private var outputName: Output<String>? = null

    private var outputSettings: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs>? =
        null

    private var videoDescriptionName: Output<String>? = null

    /**
     * @param value The names of the audio descriptions used as audio sources for the output.
     */
    @JvmName("apkjtokoxlykmxeb")
    public suspend fun audioDescriptionNames(`value`: Output<List<String>>) {
        this.audioDescriptionNames = value
    }

    @JvmName("omugbrwvpfqhrmju")
    public suspend fun audioDescriptionNames(vararg values: Output<String>) {
        this.audioDescriptionNames = Output.all(values.asList())
    }

    /**
     * @param values The names of the audio descriptions used as audio sources for the output.
     */
    @JvmName("cwlbneidbwwkuars")
    public suspend fun audioDescriptionNames(values: List<Output<String>>) {
        this.audioDescriptionNames = Output.all(values)
    }

    /**
     * @param value The names of the caption descriptions used as caption sources for the output.
     */
    @JvmName("arsglevyqoumsiyi")
    public suspend fun captionDescriptionNames(`value`: Output<List<String>>) {
        this.captionDescriptionNames = value
    }

    @JvmName("snknclaxknbeyfqn")
    public suspend fun captionDescriptionNames(vararg values: Output<String>) {
        this.captionDescriptionNames = Output.all(values.asList())
    }

    /**
     * @param values The names of the caption descriptions used as caption sources for the output.
     */
    @JvmName("upduurrjbkjbiwor")
    public suspend fun captionDescriptionNames(values: List<Output<String>>) {
        this.captionDescriptionNames = Output.all(values)
    }

    /**
     * @param value The name used to identify an output.
     */
    @JvmName("qoqwrucsokwlidfn")
    public suspend fun outputName(`value`: Output<String>) {
        this.outputName = value
    }

    /**
     * @param value Settings for output. See Output Settings for more details.
     */
    @JvmName("rmqjldvlbhvvigov")
    public suspend
    fun outputSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs>) {
        this.outputSettings = value
    }

    /**
     * @param value The name of the video description used as video source for the output.
     */
    @JvmName("fitkmdkwurdnhqwh")
    public suspend fun videoDescriptionName(`value`: Output<String>) {
        this.videoDescriptionName = value
    }

    /**
     * @param value The names of the audio descriptions used as audio sources for the output.
     */
    @JvmName("jgaouecdyrlrjrme")
    public suspend fun audioDescriptionNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioDescriptionNames = mapped
    }

    /**
     * @param values The names of the audio descriptions used as audio sources for the output.
     */
    @JvmName("pvviwrctpopmakxo")
    public suspend fun audioDescriptionNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.audioDescriptionNames = mapped
    }

    /**
     * @param value The names of the caption descriptions used as caption sources for the output.
     */
    @JvmName("tjenryprgxiveasl")
    public suspend fun captionDescriptionNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captionDescriptionNames = mapped
    }

    /**
     * @param values The names of the caption descriptions used as caption sources for the output.
     */
    @JvmName("lrkhhcbsvcdbquck")
    public suspend fun captionDescriptionNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.captionDescriptionNames = mapped
    }

    /**
     * @param value The name used to identify an output.
     */
    @JvmName("knuoogjnnaoknyke")
    public suspend fun outputName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputName = mapped
    }

    /**
     * @param value Settings for output. See Output Settings for more details.
     */
    @JvmName("ksxhuunfjubgrcss")
    public suspend
    fun outputSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputSettings = mapped
    }

    /**
     * @param argument Settings for output. See Output Settings for more details.
     */
    @JvmName("exydfykmncycwcvt")
    public suspend
    fun outputSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.outputSettings = mapped
    }

    /**
     * @param value The name of the video description used as video source for the output.
     */
    @JvmName("ttkspqoyoxkuutwu")
    public suspend fun videoDescriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoDescriptionName = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputArgs =
        ChannelEncoderSettingsOutputGroupOutputArgs(
            audioDescriptionNames = audioDescriptionNames,
            captionDescriptionNames = captionDescriptionNames,
            outputName = outputName,
            outputSettings = outputSettings ?: throw PulumiNullFieldException("outputSettings"),
            videoDescriptionName = videoDescriptionName,
        )
}
