@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property archiveGroupSettings Archive group settings. See Archive Group Settings for more details.
 * @property frameCaptureGroupSettings
 * @property hlsGroupSettings
 * @property mediaPackageGroupSettings Media package group settings. See Media Package Group Settings for more details.
 * @property msSmoothGroupSettings
 * @property multiplexGroupSettings
 * @property rtmpGroupSettings RTMP group settings. See RTMP Group Settings for more details.
 * @property udpGroupSettings
 */
public data class ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs(
    public val archiveGroupSettings:
    Output<List<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs>>? =
        null,
    public val frameCaptureGroupSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsArgs>? =
        null,
    public val hlsGroupSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsArgs>? = null,
    public val mediaPackageGroupSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsMediaPackageGroupSettingsArgs>? =
        null,
    public val msSmoothGroupSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsArgs>? = null,
    public val multiplexGroupSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsMultiplexGroupSettingsArgs>? =
        null,
    public val rtmpGroupSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettingsArgs>? = null,
    public val udpGroupSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs.builder()
            .archiveGroupSettings(
                archiveGroupSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .frameCaptureGroupSettings(
                frameCaptureGroupSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .hlsGroupSettings(hlsGroupSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mediaPackageGroupSettings(
                mediaPackageGroupSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .msSmoothGroupSettings(
                msSmoothGroupSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .multiplexGroupSettings(
                multiplexGroupSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rtmpGroupSettings(rtmpGroupSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .udpGroupSettings(
                udpGroupSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgsBuilder internal constructor() {
    private var archiveGroupSettings:
        Output<List<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs>>? =
        null

    private var frameCaptureGroupSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsArgs>? =
        null

    private var hlsGroupSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsArgs>? = null

    private var mediaPackageGroupSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsMediaPackageGroupSettingsArgs>? =
        null

    private var msSmoothGroupSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsArgs>? = null

    private var multiplexGroupSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsMultiplexGroupSettingsArgs>? = null

    private var rtmpGroupSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettingsArgs>? = null

    private var udpGroupSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettingsArgs>? = null

    /**
     * @param value Archive group settings. See Archive Group Settings for more details.
     */
    @JvmName("qxdfhcwlidtbidtn")
    public suspend
    fun archiveGroupSettings(`value`: Output<List<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs>>) {
        this.archiveGroupSettings = value
    }

    @JvmName("erpdrejkgrgedlhk")
    public suspend fun archiveGroupSettings(
        vararg
        values: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs>,
    ) {
        this.archiveGroupSettings = Output.all(values.asList())
    }

    /**
     * @param values Archive group settings. See Archive Group Settings for more details.
     */
    @JvmName("mkeobhwanunaktle")
    public suspend
    fun archiveGroupSettings(values: List<Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs>>) {
        this.archiveGroupSettings = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("dxlcpharwjqntdmg")
    public suspend
    fun frameCaptureGroupSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsArgs>) {
        this.frameCaptureGroupSettings = value
    }

    /**
     * @param value
     */
    @JvmName("dfoyohjsaetycnyr")
    public suspend
    fun hlsGroupSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsArgs>) {
        this.hlsGroupSettings = value
    }

    /**
     * @param value Media package group settings. See Media Package Group Settings for more details.
     */
    @JvmName("teqetkgkklyyneck")
    public suspend
    fun mediaPackageGroupSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsMediaPackageGroupSettingsArgs>) {
        this.mediaPackageGroupSettings = value
    }

    /**
     * @param value
     */
    @JvmName("mubadapkhoikxxek")
    public suspend
    fun msSmoothGroupSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsArgs>) {
        this.msSmoothGroupSettings = value
    }

    /**
     * @param value
     */
    @JvmName("tquegjmpmnvhmnvw")
    public suspend
    fun multiplexGroupSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsMultiplexGroupSettingsArgs>) {
        this.multiplexGroupSettings = value
    }

    /**
     * @param value RTMP group settings. See RTMP Group Settings for more details.
     */
    @JvmName("woxyhiaxijcylecg")
    public suspend
    fun rtmpGroupSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettingsArgs>) {
        this.rtmpGroupSettings = value
    }

    /**
     * @param value
     */
    @JvmName("gybxikmiexqhecsg")
    public suspend
    fun udpGroupSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettingsArgs>) {
        this.udpGroupSettings = value
    }

    /**
     * @param value Archive group settings. See Archive Group Settings for more details.
     */
    @JvmName("wnjuhsxbsgikdvba")
    public suspend
    fun archiveGroupSettings(`value`: List<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archiveGroupSettings = mapped
    }

    /**
     * @param argument Archive group settings. See Archive Group Settings for more details.
     */
    @JvmName("jsdxjxujcvaltffg")
    public suspend
    fun archiveGroupSettings(argument: List<suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.archiveGroupSettings = mapped
    }

    /**
     * @param argument Archive group settings. See Archive Group Settings for more details.
     */
    @JvmName("eiibqcxapwvqpina")
    public suspend fun archiveGroupSettings(
        vararg
        argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.archiveGroupSettings = mapped
    }

    /**
     * @param argument Archive group settings. See Archive Group Settings for more details.
     */
    @JvmName("imqhdberuqgefnwd")
    public suspend
    fun archiveGroupSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.archiveGroupSettings = mapped
    }

    /**
     * @param values Archive group settings. See Archive Group Settings for more details.
     */
    @JvmName("axxysvhhamndelvw")
    public suspend fun archiveGroupSettings(
        vararg
        values: ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.archiveGroupSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("crqmhngmhnmfhffh")
    public suspend
    fun frameCaptureGroupSettings(`value`: ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frameCaptureGroupSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fftchbvigwpararr")
    public suspend
    fun frameCaptureGroupSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.frameCaptureGroupSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("jfijasqkbgjnolqn")
    public suspend
    fun hlsGroupSettings(`value`: ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hlsGroupSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dwxpdolbvpoivelw")
    public suspend
    fun hlsGroupSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.hlsGroupSettings = mapped
    }

    /**
     * @param value Media package group settings. See Media Package Group Settings for more details.
     */
    @JvmName("rseywpsnxstpsbpu")
    public suspend
    fun mediaPackageGroupSettings(`value`: ChannelEncoderSettingsOutputGroupOutputGroupSettingsMediaPackageGroupSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaPackageGroupSettings = mapped
    }

    /**
     * @param argument Media package group settings. See Media Package Group Settings for more details.
     */
    @JvmName("wqohvtvnitkxfmtp")
    public suspend
    fun mediaPackageGroupSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsMediaPackageGroupSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsMediaPackageGroupSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.mediaPackageGroupSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("pciclkxxerokywhx")
    public suspend
    fun msSmoothGroupSettings(`value`: ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.msSmoothGroupSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("aseskmhybwnhwrym")
    public suspend
    fun msSmoothGroupSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.msSmoothGroupSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("ddjeuxrapnwbpwcc")
    public suspend
    fun multiplexGroupSettings(`value`: ChannelEncoderSettingsOutputGroupOutputGroupSettingsMultiplexGroupSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiplexGroupSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ckmveinjtkxpkhpv")
    public suspend
    fun multiplexGroupSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsMultiplexGroupSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsMultiplexGroupSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.multiplexGroupSettings = mapped
    }

    /**
     * @param value RTMP group settings. See RTMP Group Settings for more details.
     */
    @JvmName("vwhsenryhfdhkjga")
    public suspend
    fun rtmpGroupSettings(`value`: ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rtmpGroupSettings = mapped
    }

    /**
     * @param argument RTMP group settings. See RTMP Group Settings for more details.
     */
    @JvmName("buuenelclgqtpcoa")
    public suspend
    fun rtmpGroupSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.rtmpGroupSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("givenaruedxbawva")
    public suspend
    fun udpGroupSettings(`value`: ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.udpGroupSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("oguruukidgwlhago")
    public suspend
    fun udpGroupSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.udpGroupSettings = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs(
            archiveGroupSettings = archiveGroupSettings,
            frameCaptureGroupSettings = frameCaptureGroupSettings,
            hlsGroupSettings = hlsGroupSettings,
            mediaPackageGroupSettings = mediaPackageGroupSettings,
            msSmoothGroupSettings = msSmoothGroupSettings,
            multiplexGroupSettings = multiplexGroupSettings,
            rtmpGroupSettings = rtmpGroupSettings,
            udpGroupSettings = udpGroupSettings,
        )
}
