@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property destination A director and base filename where archive files should be written. See Destination for more details.
 * @property frameCaptureCdnSettings
 */
public data class ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsArgs(
    public val destination:
    Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsDestinationArgs>,
    public val frameCaptureCdnSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsFrameCaptureCdnSettingsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsArgs.builder()
            .destination(destination.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .frameCaptureCdnSettings(
                frameCaptureCdnSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsArgsBuilder
internal constructor() {
    private var destination:
        Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsDestinationArgs>? =
        null

    private var frameCaptureCdnSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsFrameCaptureCdnSettingsArgs>? =
        null

    /**
     * @param value A director and base filename where archive files should be written. See Destination for more details.
     */
    @JvmName("fmacpvacpbjytljy")
    public suspend
    fun destination(`value`: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value
     */
    @JvmName("whmvuqsomnpnffmh")
    public suspend
    fun frameCaptureCdnSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsFrameCaptureCdnSettingsArgs>) {
        this.frameCaptureCdnSettings = value
    }

    /**
     * @param value A director and base filename where archive files should be written. See Destination for more details.
     */
    @JvmName("mioijuewhqkhvxmw")
    public suspend
    fun destination(`value`: ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsDestinationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument A director and base filename where archive files should be written. See Destination for more details.
     */
    @JvmName("gnhbkbwsefrlkadi")
    public suspend
    fun destination(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsDestinationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value
     */
    @JvmName("tcxdvomabmlwoaos")
    public suspend
    fun frameCaptureCdnSettings(`value`: ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsFrameCaptureCdnSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frameCaptureCdnSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("auswqwmxnpcxbbcp")
    public suspend
    fun frameCaptureCdnSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsFrameCaptureCdnSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsFrameCaptureCdnSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.frameCaptureCdnSettings = mapped
    }

    internal fun build():
        ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettingsArgs(
            destination = destination ?: throw PulumiNullFieldException("destination"),
            frameCaptureCdnSettings = frameCaptureCdnSettings,
        )
}
