@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsAkamaiSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionRetryInterval Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
 * @property filecacheDuration
 * @property httpTransferMode
 * @property numRetries Number of retry attempts.
 * @property restartDelay Number of seconds to wait until a restart is initiated.
 * @property salt
 * @property token
 */
public data class
ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsAkamaiSettingsArgs(
    public val connectionRetryInterval: Output<Int>? = null,
    public val filecacheDuration: Output<Int>? = null,
    public val httpTransferMode: Output<String>? = null,
    public val numRetries: Output<Int>? = null,
    public val restartDelay: Output<Int>? = null,
    public val salt: Output<String>? = null,
    public val token: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsAkamaiSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsAkamaiSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsAkamaiSettingsArgs.builder()
            .connectionRetryInterval(connectionRetryInterval?.applyValue({ args0 -> args0 }))
            .filecacheDuration(filecacheDuration?.applyValue({ args0 -> args0 }))
            .httpTransferMode(httpTransferMode?.applyValue({ args0 -> args0 }))
            .numRetries(numRetries?.applyValue({ args0 -> args0 }))
            .restartDelay(restartDelay?.applyValue({ args0 -> args0 }))
            .salt(salt?.applyValue({ args0 -> args0 }))
            .token(token?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsAkamaiSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsAkamaiSettingsArgsBuilder
internal constructor() {
    private var connectionRetryInterval: Output<Int>? = null

    private var filecacheDuration: Output<Int>? = null

    private var httpTransferMode: Output<String>? = null

    private var numRetries: Output<Int>? = null

    private var restartDelay: Output<Int>? = null

    private var salt: Output<String>? = null

    private var token: Output<String>? = null

    /**
     * @param value Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
     */
    @JvmName("urbvkehmocpypsgn")
    public suspend fun connectionRetryInterval(`value`: Output<Int>) {
        this.connectionRetryInterval = value
    }

    /**
     * @param value
     */
    @JvmName("bdhfejpchmaweqtj")
    public suspend fun filecacheDuration(`value`: Output<Int>) {
        this.filecacheDuration = value
    }

    /**
     * @param value
     */
    @JvmName("mcmaljfakjoxkkex")
    public suspend fun httpTransferMode(`value`: Output<String>) {
        this.httpTransferMode = value
    }

    /**
     * @param value Number of retry attempts.
     */
    @JvmName("nxwqqfqarugabxbl")
    public suspend fun numRetries(`value`: Output<Int>) {
        this.numRetries = value
    }

    /**
     * @param value Number of seconds to wait until a restart is initiated.
     */
    @JvmName("rraugvveneqgvwcd")
    public suspend fun restartDelay(`value`: Output<Int>) {
        this.restartDelay = value
    }

    /**
     * @param value
     */
    @JvmName("cwrqyqkbphcyxsby")
    public suspend fun salt(`value`: Output<String>) {
        this.salt = value
    }

    /**
     * @param value
     */
    @JvmName("gcjfkwysrlsqxxmf")
    public suspend fun token(`value`: Output<String>) {
        this.token = value
    }

    /**
     * @param value Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
     */
    @JvmName("hunkgtwtepchyfuc")
    public suspend fun connectionRetryInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionRetryInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("wyodylmmfujqgoij")
    public suspend fun filecacheDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filecacheDuration = mapped
    }

    /**
     * @param value
     */
    @JvmName("ymclbcswqixcettj")
    public suspend fun httpTransferMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpTransferMode = mapped
    }

    /**
     * @param value Number of retry attempts.
     */
    @JvmName("kaoyvlvxqyymkxtb")
    public suspend fun numRetries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numRetries = mapped
    }

    /**
     * @param value Number of seconds to wait until a restart is initiated.
     */
    @JvmName("pflmrajdjwxljucn")
    public suspend fun restartDelay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartDelay = mapped
    }

    /**
     * @param value
     */
    @JvmName("rqaqoyluldudldxr")
    public suspend fun salt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.salt = mapped
    }

    /**
     * @param value
     */
    @JvmName("yoqbwfqwwmndqvqp")
    public suspend fun token(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.token = mapped
    }

    internal fun build():
        ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsAkamaiSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsAkamaiSettingsArgs(
            connectionRetryInterval = connectionRetryInterval,
            filecacheDuration = filecacheDuration,
            httpTransferMode = httpTransferMode,
            numRetries = numRetries,
            restartDelay = restartDelay,
            salt = salt,
            token = token,
        )
}
