@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsMediaStoreSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionRetryInterval Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
 * @property filecacheDuration
 * @property mediaStoreStorageClass
 * @property numRetries Number of retry attempts.
 * @property restartDelay Number of seconds to wait until a restart is initiated.
 */
public data class
ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsMediaStoreSettingsArgs(
    public val connectionRetryInterval: Output<Int>? = null,
    public val filecacheDuration: Output<Int>? = null,
    public val mediaStoreStorageClass: Output<String>? = null,
    public val numRetries: Output<Int>? = null,
    public val restartDelay: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsMediaStoreSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsMediaStoreSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsMediaStoreSettingsArgs.builder()
            .connectionRetryInterval(connectionRetryInterval?.applyValue({ args0 -> args0 }))
            .filecacheDuration(filecacheDuration?.applyValue({ args0 -> args0 }))
            .mediaStoreStorageClass(mediaStoreStorageClass?.applyValue({ args0 -> args0 }))
            .numRetries(numRetries?.applyValue({ args0 -> args0 }))
            .restartDelay(restartDelay?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsMediaStoreSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsMediaStoreSettingsArgsBuilder
internal constructor() {
    private var connectionRetryInterval: Output<Int>? = null

    private var filecacheDuration: Output<Int>? = null

    private var mediaStoreStorageClass: Output<String>? = null

    private var numRetries: Output<Int>? = null

    private var restartDelay: Output<Int>? = null

    /**
     * @param value Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
     */
    @JvmName("vvyjobdyrwsjcgyo")
    public suspend fun connectionRetryInterval(`value`: Output<Int>) {
        this.connectionRetryInterval = value
    }

    /**
     * @param value
     */
    @JvmName("kcltbggxjqfflbre")
    public suspend fun filecacheDuration(`value`: Output<Int>) {
        this.filecacheDuration = value
    }

    /**
     * @param value
     */
    @JvmName("wqqtcqrpsalohxdp")
    public suspend fun mediaStoreStorageClass(`value`: Output<String>) {
        this.mediaStoreStorageClass = value
    }

    /**
     * @param value Number of retry attempts.
     */
    @JvmName("uppnyqexkbgcfouy")
    public suspend fun numRetries(`value`: Output<Int>) {
        this.numRetries = value
    }

    /**
     * @param value Number of seconds to wait until a restart is initiated.
     */
    @JvmName("qfxlqelfgnflxgwh")
    public suspend fun restartDelay(`value`: Output<Int>) {
        this.restartDelay = value
    }

    /**
     * @param value Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
     */
    @JvmName("tbleaydsbdnvfqtm")
    public suspend fun connectionRetryInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionRetryInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("qirwacckoyjjydjc")
    public suspend fun filecacheDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filecacheDuration = mapped
    }

    /**
     * @param value
     */
    @JvmName("liniiyilvfissfnb")
    public suspend fun mediaStoreStorageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaStoreStorageClass = mapped
    }

    /**
     * @param value Number of retry attempts.
     */
    @JvmName("dpvmouptsgttvsus")
    public suspend fun numRetries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numRetries = mapped
    }

    /**
     * @param value Number of seconds to wait until a restart is initiated.
     */
    @JvmName("yrimasdnaxsxbkgx")
    public suspend fun restartDelay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartDelay = mapped
    }

    internal fun build():
        ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsMediaStoreSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsHlsCdnSettingHlsMediaStoreSettingsArgs(
            connectionRetryInterval = connectionRetryInterval,
            filecacheDuration = filecacheDuration,
            mediaStoreStorageClass = mediaStoreStorageClass,
            numRetries = numRetries,
            restartDelay = restartDelay,
        )
}
