@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsKeyProviderSettingsStaticKeySettingKeyProviderServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property passwordParam Key used to extract the password from EC2 Parameter store.
 * @property uri Path to a file accessible to the live stream.
 * @property username . Username to be used.
 */
public data class
ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsKeyProviderSettingsStaticKeySettingKeyProviderServerArgs(
    public val passwordParam: Output<String>? = null,
    public val uri: Output<String>,
    public val username: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsKeyProviderSettingsStaticKeySettingKeyProviderServerArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsKeyProviderSettingsStaticKeySettingKeyProviderServerArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsKeyProviderSettingsStaticKeySettingKeyProviderServerArgs.builder()
            .passwordParam(passwordParam?.applyValue({ args0 -> args0 }))
            .uri(uri.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsKeyProviderSettingsStaticKeySettingKeyProviderServerArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsKeyProviderSettingsStaticKeySettingKeyProviderServerArgsBuilder
internal constructor() {
    private var passwordParam: Output<String>? = null

    private var uri: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Key used to extract the password from EC2 Parameter store.
     */
    @JvmName("bvrocdyrmfwgidxk")
    public suspend fun passwordParam(`value`: Output<String>) {
        this.passwordParam = value
    }

    /**
     * @param value Path to a file accessible to the live stream.
     */
    @JvmName("agwsfkmbdgxclulo")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value . Username to be used.
     */
    @JvmName("jrvofnnmvmubrgto")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Key used to extract the password from EC2 Parameter store.
     */
    @JvmName("qtlaggumruhyxqpy")
    public suspend fun passwordParam(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordParam = mapped
    }

    /**
     * @param value Path to a file accessible to the live stream.
     */
    @JvmName("wcyjjomjaotfpwpt")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    /**
     * @param value . Username to be used.
     */
    @JvmName("itgtpassalocmkqh")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build():
        ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsKeyProviderSettingsStaticKeySettingKeyProviderServerArgs =
        ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettingsKeyProviderSettingsStaticKeySettingKeyProviderServerArgs(
            passwordParam = passwordParam,
            uri = uri ?: throw PulumiNullFieldException("uri"),
            username = username,
        )
}
