@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property adMarkers The ad marker type for this output group.
 * @property authenticationScheme Authentication scheme to use when connecting with CDN.
 * @property cacheFullBehavior Controls behavior when content cache fills up.
 * @property cacheLength Cache length in seconds, is used to calculate buffer size.
 * @property captionData Controls the types of data that passes to onCaptionInfo outputs.
 * @property inputLossAction Controls the behavior of the RTMP group if input becomes unavailable.
 * @property restartDelay Number of seconds to wait until a restart is initiated.
 */
public data class ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettingsArgs(
    public val adMarkers: Output<List<String>>? = null,
    public val authenticationScheme: Output<String>? = null,
    public val cacheFullBehavior: Output<String>? = null,
    public val cacheLength: Output<Int>? = null,
    public val captionData: Output<String>? = null,
    public val inputLossAction: Output<String>? = null,
    public val restartDelay: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettingsArgs.builder()
            .adMarkers(adMarkers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationScheme(authenticationScheme?.applyValue({ args0 -> args0 }))
            .cacheFullBehavior(cacheFullBehavior?.applyValue({ args0 -> args0 }))
            .cacheLength(cacheLength?.applyValue({ args0 -> args0 }))
            .captionData(captionData?.applyValue({ args0 -> args0 }))
            .inputLossAction(inputLossAction?.applyValue({ args0 -> args0 }))
            .restartDelay(restartDelay?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettingsArgsBuilder
internal constructor() {
    private var adMarkers: Output<List<String>>? = null

    private var authenticationScheme: Output<String>? = null

    private var cacheFullBehavior: Output<String>? = null

    private var cacheLength: Output<Int>? = null

    private var captionData: Output<String>? = null

    private var inputLossAction: Output<String>? = null

    private var restartDelay: Output<Int>? = null

    /**
     * @param value The ad marker type for this output group.
     */
    @JvmName("fnvdofajijxscufy")
    public suspend fun adMarkers(`value`: Output<List<String>>) {
        this.adMarkers = value
    }

    @JvmName("gciowhainvwfhles")
    public suspend fun adMarkers(vararg values: Output<String>) {
        this.adMarkers = Output.all(values.asList())
    }

    /**
     * @param values The ad marker type for this output group.
     */
    @JvmName("uxwpflfnkhgyctac")
    public suspend fun adMarkers(values: List<Output<String>>) {
        this.adMarkers = Output.all(values)
    }

    /**
     * @param value Authentication scheme to use when connecting with CDN.
     */
    @JvmName("ufbsndhbfjvlhqgf")
    public suspend fun authenticationScheme(`value`: Output<String>) {
        this.authenticationScheme = value
    }

    /**
     * @param value Controls behavior when content cache fills up.
     */
    @JvmName("kcaeafjhqywbqlrr")
    public suspend fun cacheFullBehavior(`value`: Output<String>) {
        this.cacheFullBehavior = value
    }

    /**
     * @param value Cache length in seconds, is used to calculate buffer size.
     */
    @JvmName("nbamnlgsqxqbvofe")
    public suspend fun cacheLength(`value`: Output<Int>) {
        this.cacheLength = value
    }

    /**
     * @param value Controls the types of data that passes to onCaptionInfo outputs.
     */
    @JvmName("yeddiroeqoxpwfrn")
    public suspend fun captionData(`value`: Output<String>) {
        this.captionData = value
    }

    /**
     * @param value Controls the behavior of the RTMP group if input becomes unavailable.
     */
    @JvmName("eldbckymfvcoakap")
    public suspend fun inputLossAction(`value`: Output<String>) {
        this.inputLossAction = value
    }

    /**
     * @param value Number of seconds to wait until a restart is initiated.
     */
    @JvmName("amstrpxoaekmkcov")
    public suspend fun restartDelay(`value`: Output<Int>) {
        this.restartDelay = value
    }

    /**
     * @param value The ad marker type for this output group.
     */
    @JvmName("xuhogxerdrycuamh")
    public suspend fun adMarkers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adMarkers = mapped
    }

    /**
     * @param values The ad marker type for this output group.
     */
    @JvmName("qentjnjjtcicshbg")
    public suspend fun adMarkers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adMarkers = mapped
    }

    /**
     * @param value Authentication scheme to use when connecting with CDN.
     */
    @JvmName("hvybqurjfeohddss")
    public suspend fun authenticationScheme(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationScheme = mapped
    }

    /**
     * @param value Controls behavior when content cache fills up.
     */
    @JvmName("ciqvoobtjpncfvcy")
    public suspend fun cacheFullBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheFullBehavior = mapped
    }

    /**
     * @param value Cache length in seconds, is used to calculate buffer size.
     */
    @JvmName("tnyuyrasmmyqmcvn")
    public suspend fun cacheLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheLength = mapped
    }

    /**
     * @param value Controls the types of data that passes to onCaptionInfo outputs.
     */
    @JvmName("qljomgiggowxchlc")
    public suspend fun captionData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captionData = mapped
    }

    /**
     * @param value Controls the behavior of the RTMP group if input becomes unavailable.
     */
    @JvmName("nverhnbljrlbpnae")
    public suspend fun inputLossAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputLossAction = mapped
    }

    /**
     * @param value Number of seconds to wait until a restart is initiated.
     */
    @JvmName("ijhdhiqmfowyitgh")
    public suspend fun restartDelay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartDelay = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettingsArgs(
            adMarkers = adMarkers,
            authenticationScheme = authenticationScheme,
            cacheFullBehavior = cacheFullBehavior,
            cacheLength = cacheLength,
            captionData = captionData,
            inputLossAction = inputLossAction,
            restartDelay = restartDelay,
        )
}
