@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property inputLossAction Specifies behavior of last resort when input video os lost.
 * @property timedMetadataId3Frame Indicates ID3 frame that has the timecode.
 * @property timedMetadataId3Period
 */
public data class ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettingsArgs(
    public val inputLossAction: Output<String>? = null,
    public val timedMetadataId3Frame: Output<String>? = null,
    public val timedMetadataId3Period: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettingsArgs.builder()
            .inputLossAction(inputLossAction?.applyValue({ args0 -> args0 }))
            .timedMetadataId3Frame(timedMetadataId3Frame?.applyValue({ args0 -> args0 }))
            .timedMetadataId3Period(timedMetadataId3Period?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettingsArgsBuilder
internal constructor() {
    private var inputLossAction: Output<String>? = null

    private var timedMetadataId3Frame: Output<String>? = null

    private var timedMetadataId3Period: Output<Int>? = null

    /**
     * @param value Specifies behavior of last resort when input video os lost.
     */
    @JvmName("hdtlebsnrxpqqugn")
    public suspend fun inputLossAction(`value`: Output<String>) {
        this.inputLossAction = value
    }

    /**
     * @param value Indicates ID3 frame that has the timecode.
     */
    @JvmName("dvqjdgahwsfwpqld")
    public suspend fun timedMetadataId3Frame(`value`: Output<String>) {
        this.timedMetadataId3Frame = value
    }

    /**
     * @param value
     */
    @JvmName("dmuqotwwbustjbhj")
    public suspend fun timedMetadataId3Period(`value`: Output<Int>) {
        this.timedMetadataId3Period = value
    }

    /**
     * @param value Specifies behavior of last resort when input video os lost.
     */
    @JvmName("rktufypyoitibbpi")
    public suspend fun inputLossAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputLossAction = mapped
    }

    /**
     * @param value Indicates ID3 frame that has the timecode.
     */
    @JvmName("pcsealpdgorpnjvq")
    public suspend fun timedMetadataId3Frame(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timedMetadataId3Frame = mapped
    }

    /**
     * @param value
     */
    @JvmName("xdgkmrfttkxnwfll")
    public suspend fun timedMetadataId3Period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timedMetadataId3Period = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettingsArgs(
            inputLossAction = inputLossAction,
            timedMetadataId3Frame = timedMetadataId3Frame,
            timedMetadataId3Period = timedMetadataId3Period,
        )
}
