@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property archiveOutputSettings Archive output settings. See Archive Output Settings for more details.
 * @property frameCaptureOutputSettings
 * @property hlsOutputSettings
 * @property mediaPackageOutputSettings Media package output settings. This can be set as an empty block.
 * @property msSmoothOutputSettings
 * @property multiplexOutputSettings Multiplex output settings. See Multiplex Output Settings for more details.
 * @property rtmpOutputSettings RTMP output settings. See RTMP Output Settings for more details.
 * @property udpOutputSettings UDP output settings. See UDP Output Settings for more details.
 */
public data class ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs(
    public val archiveOutputSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs>? =
        null,
    public val frameCaptureOutputSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsFrameCaptureOutputSettingsArgs>? =
        null,
    public val hlsOutputSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsArgs>? = null,
    public val mediaPackageOutputSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsMediaPackageOutputSettingsArgs>? =
        null,
    public val msSmoothOutputSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettingsArgs>? =
        null,
    public val multiplexOutputSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsMultiplexOutputSettingsArgs>? =
        null,
    public val rtmpOutputSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsArgs>? = null,
    public val udpOutputSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs.builder()
            .archiveOutputSettings(
                archiveOutputSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .frameCaptureOutputSettings(
                frameCaptureOutputSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .hlsOutputSettings(hlsOutputSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mediaPackageOutputSettings(
                mediaPackageOutputSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .msSmoothOutputSettings(
                msSmoothOutputSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .multiplexOutputSettings(
                multiplexOutputSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rtmpOutputSettings(
                rtmpOutputSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .udpOutputSettings(
                udpOutputSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgsBuilder internal constructor() {
    private var archiveOutputSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs>? = null

    private var frameCaptureOutputSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsFrameCaptureOutputSettingsArgs>? =
        null

    private var hlsOutputSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsArgs>? = null

    private var mediaPackageOutputSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsMediaPackageOutputSettingsArgs>? =
        null

    private var msSmoothOutputSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettingsArgs>? =
        null

    private var multiplexOutputSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsMultiplexOutputSettingsArgs>? =
        null

    private var rtmpOutputSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsArgs>? = null

    private var udpOutputSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsArgs>? = null

    /**
     * @param value Archive output settings. See Archive Output Settings for more details.
     */
    @JvmName("ydxnpflanxoqfpic")
    public suspend
    fun archiveOutputSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs>) {
        this.archiveOutputSettings = value
    }

    /**
     * @param value
     */
    @JvmName("omkisgavyusewhau")
    public suspend
    fun frameCaptureOutputSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsFrameCaptureOutputSettingsArgs>) {
        this.frameCaptureOutputSettings = value
    }

    /**
     * @param value
     */
    @JvmName("lvfmtexogakcoxpp")
    public suspend
    fun hlsOutputSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsArgs>) {
        this.hlsOutputSettings = value
    }

    /**
     * @param value Media package output settings. This can be set as an empty block.
     */
    @JvmName("tfeakwgclkivsawp")
    public suspend
    fun mediaPackageOutputSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsMediaPackageOutputSettingsArgs>) {
        this.mediaPackageOutputSettings = value
    }

    /**
     * @param value
     */
    @JvmName("cydxhkhqeqfkeyav")
    public suspend
    fun msSmoothOutputSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettingsArgs>) {
        this.msSmoothOutputSettings = value
    }

    /**
     * @param value Multiplex output settings. See Multiplex Output Settings for more details.
     */
    @JvmName("tgywyuevtxuwcqcq")
    public suspend
    fun multiplexOutputSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsMultiplexOutputSettingsArgs>) {
        this.multiplexOutputSettings = value
    }

    /**
     * @param value RTMP output settings. See RTMP Output Settings for more details.
     */
    @JvmName("ynosjbpgfqaffvbb")
    public suspend
    fun rtmpOutputSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsArgs>) {
        this.rtmpOutputSettings = value
    }

    /**
     * @param value UDP output settings. See UDP Output Settings for more details.
     */
    @JvmName("bvgkklactxxpcubg")
    public suspend
    fun udpOutputSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsArgs>) {
        this.udpOutputSettings = value
    }

    /**
     * @param value Archive output settings. See Archive Output Settings for more details.
     */
    @JvmName("bkeojxpeoypqrqmv")
    public suspend
    fun archiveOutputSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archiveOutputSettings = mapped
    }

    /**
     * @param argument Archive output settings. See Archive Output Settings for more details.
     */
    @JvmName("fqgymoeoyfhujkbf")
    public suspend
    fun archiveOutputSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.archiveOutputSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("choffxqojrulmjrw")
    public suspend
    fun frameCaptureOutputSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsFrameCaptureOutputSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frameCaptureOutputSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("aqbvxdmsqohayvxy")
    public suspend
    fun frameCaptureOutputSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsFrameCaptureOutputSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsFrameCaptureOutputSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.frameCaptureOutputSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("chrxtuenwgbnqspc")
    public suspend
    fun hlsOutputSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hlsOutputSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ikftixlsxmgcconm")
    public suspend
    fun hlsOutputSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.hlsOutputSettings = mapped
    }

    /**
     * @param value Media package output settings. This can be set as an empty block.
     */
    @JvmName("nmvxbxffpuamltxa")
    public suspend
    fun mediaPackageOutputSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsMediaPackageOutputSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaPackageOutputSettings = mapped
    }

    /**
     * @param argument Media package output settings. This can be set as an empty block.
     */
    @JvmName("kqgaphahqigwrkyh")
    public suspend
    fun mediaPackageOutputSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsMediaPackageOutputSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsMediaPackageOutputSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.mediaPackageOutputSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("caohghiqgcdwwfem")
    public suspend
    fun msSmoothOutputSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.msSmoothOutputSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nonimotsdxjqlfos")
    public suspend
    fun msSmoothOutputSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.msSmoothOutputSettings = mapped
    }

    /**
     * @param value Multiplex output settings. See Multiplex Output Settings for more details.
     */
    @JvmName("jatgmwtvndvexfyn")
    public suspend
    fun multiplexOutputSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsMultiplexOutputSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiplexOutputSettings = mapped
    }

    /**
     * @param argument Multiplex output settings. See Multiplex Output Settings for more details.
     */
    @JvmName("pjwbdmiqsyahmdbn")
    public suspend
    fun multiplexOutputSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsMultiplexOutputSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsMultiplexOutputSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.multiplexOutputSettings = mapped
    }

    /**
     * @param value RTMP output settings. See RTMP Output Settings for more details.
     */
    @JvmName("hayohmieenviveev")
    public suspend
    fun rtmpOutputSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rtmpOutputSettings = mapped
    }

    /**
     * @param argument RTMP output settings. See RTMP Output Settings for more details.
     */
    @JvmName("tkdabvndcwyyfhpa")
    public suspend
    fun rtmpOutputSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.rtmpOutputSettings = mapped
    }

    /**
     * @param value UDP output settings. See UDP Output Settings for more details.
     */
    @JvmName("iwxtmuvbxhkeoquk")
    public suspend
    fun udpOutputSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.udpOutputSettings = mapped
    }

    /**
     * @param argument UDP output settings. See UDP Output Settings for more details.
     */
    @JvmName("dgyqihbkkcjbgiuy")
    public suspend
    fun udpOutputSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.udpOutputSettings = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs(
            archiveOutputSettings = archiveOutputSettings,
            frameCaptureOutputSettings = frameCaptureOutputSettings,
            hlsOutputSettings = hlsOutputSettings,
            mediaPackageOutputSettings = mediaPackageOutputSettings,
            msSmoothOutputSettings = msSmoothOutputSettings,
            multiplexOutputSettings = multiplexOutputSettings,
            rtmpOutputSettings = rtmpOutputSettings,
            udpOutputSettings = udpOutputSettings,
        )
}
