@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property h265PackagingType
 * @property hlsSettings
 * @property nameModifier String concatenated to the end of the destination filename. Required for multiple outputs of the same type.
 * @property segmentModifier
 */
public data class ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsArgs(
    public val h265PackagingType: Output<String>? = null,
    public val hlsSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsHlsSettingsArgs>,
    public val nameModifier: Output<String>? = null,
    public val segmentModifier: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsArgs.builder()
            .h265PackagingType(h265PackagingType?.applyValue({ args0 -> args0 }))
            .hlsSettings(hlsSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nameModifier(nameModifier?.applyValue({ args0 -> args0 }))
            .segmentModifier(segmentModifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsArgsBuilder
internal constructor() {
    private var h265PackagingType: Output<String>? = null

    private var hlsSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsHlsSettingsArgs>? =
        null

    private var nameModifier: Output<String>? = null

    private var segmentModifier: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("eacxpdkqfchuolqd")
    public suspend fun h265PackagingType(`value`: Output<String>) {
        this.h265PackagingType = value
    }

    /**
     * @param value
     */
    @JvmName("pxiwrhdmtbyavcno")
    public suspend
    fun hlsSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsHlsSettingsArgs>) {
        this.hlsSettings = value
    }

    /**
     * @param value String concatenated to the end of the destination filename. Required for multiple outputs of the same type.
     */
    @JvmName("dplgigydqfeuglhd")
    public suspend fun nameModifier(`value`: Output<String>) {
        this.nameModifier = value
    }

    /**
     * @param value
     */
    @JvmName("jquupfvlomytprms")
    public suspend fun segmentModifier(`value`: Output<String>) {
        this.segmentModifier = value
    }

    /**
     * @param value
     */
    @JvmName("kgpbghfpdpoqkmwx")
    public suspend fun h265PackagingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.h265PackagingType = mapped
    }

    /**
     * @param value
     */
    @JvmName("hqhonsmcaqnskeab")
    public suspend
    fun hlsSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsHlsSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hlsSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cokavakqbmhhugfr")
    public suspend
    fun hlsSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsHlsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsHlsSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.hlsSettings = mapped
    }

    /**
     * @param value String concatenated to the end of the destination filename. Required for multiple outputs of the same type.
     */
    @JvmName("lirakpebvvnbymsd")
    public suspend fun nameModifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameModifier = mapped
    }

    /**
     * @param value
     */
    @JvmName("fkwpqurihdftjcmc")
    public suspend fun segmentModifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentModifier = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettingsArgs(
            h265PackagingType = h265PackagingType,
            hlsSettings = hlsSettings ?: throw PulumiNullFieldException("hlsSettings"),
            nameModifier = nameModifier,
            segmentModifier = segmentModifier,
        )
}
