@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property certificateMode Setting to allow self signed or verified RTMP certificates.
 * @property connectionRetryInterval Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
 * @property destination The RTMP endpoint excluding the stream name. See Destination for more details.
 * @property numRetries Number of retry attempts.
 */
public data class ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsArgs(
    public val certificateMode: Output<String>? = null,
    public val connectionRetryInterval: Output<Int>? = null,
    public val destination:
    Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsDestinationArgs>,
    public val numRetries: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsArgs.builder()
            .certificateMode(certificateMode?.applyValue({ args0 -> args0 }))
            .connectionRetryInterval(connectionRetryInterval?.applyValue({ args0 -> args0 }))
            .destination(destination.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .numRetries(numRetries?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsArgsBuilder
internal constructor() {
    private var certificateMode: Output<String>? = null

    private var connectionRetryInterval: Output<Int>? = null

    private var destination:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsDestinationArgs>? =
        null

    private var numRetries: Output<Int>? = null

    /**
     * @param value Setting to allow self signed or verified RTMP certificates.
     */
    @JvmName("dbxgilrhbnaifrnf")
    public suspend fun certificateMode(`value`: Output<String>) {
        this.certificateMode = value
    }

    /**
     * @param value Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
     */
    @JvmName("hgjuhganccknjcav")
    public suspend fun connectionRetryInterval(`value`: Output<Int>) {
        this.connectionRetryInterval = value
    }

    /**
     * @param value The RTMP endpoint excluding the stream name. See Destination for more details.
     */
    @JvmName("isximutqwdxbcjmq")
    public suspend
    fun destination(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value Number of retry attempts.
     */
    @JvmName("bbjjnyhrqhdlgise")
    public suspend fun numRetries(`value`: Output<Int>) {
        this.numRetries = value
    }

    /**
     * @param value Setting to allow self signed or verified RTMP certificates.
     */
    @JvmName("ohwknqdnbxabqori")
    public suspend fun certificateMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateMode = mapped
    }

    /**
     * @param value Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
     */
    @JvmName("hhhpoctocxwocobq")
    public suspend fun connectionRetryInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionRetryInterval = mapped
    }

    /**
     * @param value The RTMP endpoint excluding the stream name. See Destination for more details.
     */
    @JvmName("svyglviiswiyepxs")
    public suspend
    fun destination(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsDestinationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument The RTMP endpoint excluding the stream name. See Destination for more details.
     */
    @JvmName("halutlaijlmtgamf")
    public suspend
    fun destination(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsDestinationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value Number of retry attempts.
     */
    @JvmName("wwoywgvrhsvhnqdu")
    public suspend fun numRetries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numRetries = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsArgs(
            certificateMode = certificateMode,
            connectionRetryInterval = connectionRetryInterval,
            destination = destination ?: throw PulumiNullFieldException("destination"),
            numRetries = numRetries,
        )
}
