@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bufferMsec UDP output buffering in milliseconds.
 * @property containerSettings UDP container settings. See Container Settings for more details.
 * @property destination Destination address and port number for RTP or UDP packets. See Destination for more details.
 * @property fecOutputSettings
 */
public data class ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsArgs(
    public val bufferMsec: Output<Int>? = null,
    public val containerSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsArgs>,
    public val destination:
    Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsDestinationArgs>,
    public val fecOutputSettings:
    Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettingsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsArgs.builder()
            .bufferMsec(bufferMsec?.applyValue({ args0 -> args0 }))
            .containerSettings(containerSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .destination(destination.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fecOutputSettings(
                fecOutputSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsArgsBuilder
internal constructor() {
    private var bufferMsec: Output<Int>? = null

    private var containerSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsArgs>? =
        null

    private var destination:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsDestinationArgs>? =
        null

    private var fecOutputSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettingsArgs>? =
        null

    /**
     * @param value UDP output buffering in milliseconds.
     */
    @JvmName("fitirllsskvpekcm")
    public suspend fun bufferMsec(`value`: Output<Int>) {
        this.bufferMsec = value
    }

    /**
     * @param value UDP container settings. See Container Settings for more details.
     */
    @JvmName("fycvnpacdpfmelux")
    public suspend
    fun containerSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsArgs>) {
        this.containerSettings = value
    }

    /**
     * @param value Destination address and port number for RTP or UDP packets. See Destination for more details.
     */
    @JvmName("lpedmawwplqwdopt")
    public suspend
    fun destination(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value
     */
    @JvmName("hplsqfxptimnwqum")
    public suspend
    fun fecOutputSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettingsArgs>) {
        this.fecOutputSettings = value
    }

    /**
     * @param value UDP output buffering in milliseconds.
     */
    @JvmName("cvtqyqhjhemdrhqu")
    public suspend fun bufferMsec(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferMsec = mapped
    }

    /**
     * @param value UDP container settings. See Container Settings for more details.
     */
    @JvmName("hlwgguvavydbfudl")
    public suspend
    fun containerSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerSettings = mapped
    }

    /**
     * @param argument UDP container settings. See Container Settings for more details.
     */
    @JvmName("keqpvyuyfgmhtxer")
    public suspend
    fun containerSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.containerSettings = mapped
    }

    /**
     * @param value Destination address and port number for RTP or UDP packets. See Destination for more details.
     */
    @JvmName("ggwmtwntqgroofjb")
    public suspend
    fun destination(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsDestinationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Destination address and port number for RTP or UDP packets. See Destination for more details.
     */
    @JvmName("hqvbmiaxouddxysx")
    public suspend
    fun destination(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsDestinationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value
     */
    @JvmName("swacpcdmiiabdcst")
    public suspend
    fun fecOutputSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fecOutputSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xhvqextvnjgexbqx")
    public suspend
    fun fecOutputSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fecOutputSettings = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsArgs(
            bufferMsec = bufferMsec,
            containerSettings = containerSettings ?: throw PulumiNullFieldException("containerSettings"),
            destination = destination ?: throw PulumiNullFieldException("destination"),
            fecOutputSettings = fecOutputSettings,
        )
}
