@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property columnDepth The height of the FEC protection matrix.
 * @property includeFec Enables column only or column and row based FEC.
 * @property rowLength The width of the FEC protection matrix.
 */
public data class
ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettingsArgs(
    public val columnDepth: Output<Int>? = null,
    public val includeFec: Output<String>? = null,
    public val rowLength: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettingsArgs.builder()
            .columnDepth(columnDepth?.applyValue({ args0 -> args0 }))
            .includeFec(includeFec?.applyValue({ args0 -> args0 }))
            .rowLength(rowLength?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettingsArgsBuilder
internal constructor() {
    private var columnDepth: Output<Int>? = null

    private var includeFec: Output<String>? = null

    private var rowLength: Output<Int>? = null

    /**
     * @param value The height of the FEC protection matrix.
     */
    @JvmName("airbirxgqlgkipib")
    public suspend fun columnDepth(`value`: Output<Int>) {
        this.columnDepth = value
    }

    /**
     * @param value Enables column only or column and row based FEC.
     */
    @JvmName("gbahhuarhgkdicya")
    public suspend fun includeFec(`value`: Output<String>) {
        this.includeFec = value
    }

    /**
     * @param value The width of the FEC protection matrix.
     */
    @JvmName("wqwafjdhudmruvic")
    public suspend fun rowLength(`value`: Output<Int>) {
        this.rowLength = value
    }

    /**
     * @param value The height of the FEC protection matrix.
     */
    @JvmName("uqaenqihsiqlirho")
    public suspend fun columnDepth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnDepth = mapped
    }

    /**
     * @param value Enables column only or column and row based FEC.
     */
    @JvmName("ctoxvfaveywqojyf")
    public suspend fun includeFec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeFec = mapped
    }

    /**
     * @param value The width of the FEC protection matrix.
     */
    @JvmName("ptjqowgcceytgsyd")
    public suspend fun rowLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rowLength = mapped
    }

    internal fun build():
        ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettingsArgs(
            columnDepth = columnDepth,
            includeFec = includeFec,
            rowLength = rowLength,
        )
}
