@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsTimecodeConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property source The source for the timecode that will be associated with the events outputs.
 * @property syncThreshold Threshold in frames beyond which output timecode is resynchronized to the input timecode.
 */
public data class ChannelEncoderSettingsTimecodeConfigArgs(
    public val source: Output<String>,
    public val syncThreshold: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsTimecodeConfigArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsTimecodeConfigArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsTimecodeConfigArgs.builder()
            .source(source.applyValue({ args0 -> args0 }))
            .syncThreshold(syncThreshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsTimecodeConfigArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsTimecodeConfigArgsBuilder internal constructor() {
    private var source: Output<String>? = null

    private var syncThreshold: Output<Int>? = null

    /**
     * @param value The source for the timecode that will be associated with the events outputs.
     */
    @JvmName("kihbelulcfppwxqw")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Threshold in frames beyond which output timecode is resynchronized to the input timecode.
     */
    @JvmName("kcjpjwnbeghgvbqa")
    public suspend fun syncThreshold(`value`: Output<Int>) {
        this.syncThreshold = value
    }

    /**
     * @param value The source for the timecode that will be associated with the events outputs.
     */
    @JvmName("hufvwhoymdwdxqjw")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Threshold in frames beyond which output timecode is resynchronized to the input timecode.
     */
    @JvmName("enblfftqhjecsnxt")
    public suspend fun syncThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncThreshold = mapped
    }

    internal fun build(): ChannelEncoderSettingsTimecodeConfigArgs =
        ChannelEncoderSettingsTimecodeConfigArgs(
            source = source ?: throw PulumiNullFieldException("source"),
            syncThreshold = syncThreshold,
        )
}
