@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property adaptiveQuantization Enables or disables adaptive quantization.
 * @property afdSignaling Indicates that AFD values will be written into the output stream.
 * @property bitrate Average bitrate in bits/second.
 * @property bufFillPct
 * @property bufSize Size of buffer in bits.
 * @property colorMetadata Includes color space metadata in the output.
 * @property entropyEncoding Entropy encoding mode.
 * @property filterSettings Filters to apply to an encode. See H265 Filter Settings for more details.
 * @property fixedAfd Four bit AFD value to write on all frames of video in the output stream.
 * @property flickerAq
 * @property forceFieldPictures Controls whether coding is performed on a field basis or on a frame basis.
 * @property framerateControl Indicates how the output video frame rate is specified.
 * @property framerateDenominator Framerate denominator.
 * @property framerateNumerator Framerate numerator.
 * @property gopBReference GOP-B reference.
 * @property gopClosedCadence Frequency of closed GOPs.
 * @property gopNumBFrames Number of B-frames between reference frames.
 * @property gopSize GOP size in units of either frames of seconds per `gop_size_units`.
 * @property gopSizeUnits Indicates if the `gop_size` is specified in frames or seconds.
 * @property level H265 level.
 * @property lookAheadRateControl Amount of lookahead.
 * @property maxBitrate Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
 * @property minIInterval
 * @property numRefFrames Number of reference frames to use.
 * @property parControl Indicates how the output pixel aspect ratio is specified.
 * @property parDenominator Pixel Aspect Ratio denominator.
 * @property parNumerator Pixel Aspect Ratio numerator.
 * @property profile AAC profile.
 * @property qualityLevel Quality level.
 * @property qvbrQualityLevel Controls the target quality for the video encode.
 * @property rateControlMode The rate control mode.
 * @property scanType Sets the scan type of the output.
 * @property sceneChangeDetect Scene change detection.
 * @property slices Number of slices per picture.
 * @property softness Softness.
 * @property spatialAq Makes adjustments within each frame based on spatial variation of content complexity.
 * @property subgopLength Subgop length.
 * @property syntax Produces a bitstream compliant with SMPTE RP-2027.
 * @property temporalAq Makes adjustments within each frame based on temporal variation of content complexity.
 * @property timecodeInsertion Determines how timecodes should be inserted into the video elementary stream.
 */
public data class ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsArgs(
    public val adaptiveQuantization: Output<String>? = null,
    public val afdSignaling: Output<String>? = null,
    public val bitrate: Output<Int>? = null,
    public val bufFillPct: Output<Int>? = null,
    public val bufSize: Output<Int>? = null,
    public val colorMetadata: Output<String>? = null,
    public val entropyEncoding: Output<String>? = null,
    public val filterSettings:
    Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsFilterSettingsArgs>? =
        null,
    public val fixedAfd: Output<String>? = null,
    public val flickerAq: Output<String>? = null,
    public val forceFieldPictures: Output<String>? = null,
    public val framerateControl: Output<String>? = null,
    public val framerateDenominator: Output<Int>? = null,
    public val framerateNumerator: Output<Int>? = null,
    public val gopBReference: Output<String>? = null,
    public val gopClosedCadence: Output<Int>? = null,
    public val gopNumBFrames: Output<Int>? = null,
    public val gopSize: Output<Double>? = null,
    public val gopSizeUnits: Output<String>? = null,
    public val level: Output<String>? = null,
    public val lookAheadRateControl: Output<String>? = null,
    public val maxBitrate: Output<Int>? = null,
    public val minIInterval: Output<Int>? = null,
    public val numRefFrames: Output<Int>? = null,
    public val parControl: Output<String>? = null,
    public val parDenominator: Output<Int>? = null,
    public val parNumerator: Output<Int>? = null,
    public val profile: Output<String>? = null,
    public val qualityLevel: Output<String>? = null,
    public val qvbrQualityLevel: Output<Int>? = null,
    public val rateControlMode: Output<String>? = null,
    public val scanType: Output<String>? = null,
    public val sceneChangeDetect: Output<String>? = null,
    public val slices: Output<Int>? = null,
    public val softness: Output<Int>? = null,
    public val spatialAq: Output<String>? = null,
    public val subgopLength: Output<String>? = null,
    public val syntax: Output<String>? = null,
    public val temporalAq: Output<String>? = null,
    public val timecodeInsertion: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsArgs.builder()
            .adaptiveQuantization(adaptiveQuantization?.applyValue({ args0 -> args0 }))
            .afdSignaling(afdSignaling?.applyValue({ args0 -> args0 }))
            .bitrate(bitrate?.applyValue({ args0 -> args0 }))
            .bufFillPct(bufFillPct?.applyValue({ args0 -> args0 }))
            .bufSize(bufSize?.applyValue({ args0 -> args0 }))
            .colorMetadata(colorMetadata?.applyValue({ args0 -> args0 }))
            .entropyEncoding(entropyEncoding?.applyValue({ args0 -> args0 }))
            .filterSettings(filterSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fixedAfd(fixedAfd?.applyValue({ args0 -> args0 }))
            .flickerAq(flickerAq?.applyValue({ args0 -> args0 }))
            .forceFieldPictures(forceFieldPictures?.applyValue({ args0 -> args0 }))
            .framerateControl(framerateControl?.applyValue({ args0 -> args0 }))
            .framerateDenominator(framerateDenominator?.applyValue({ args0 -> args0 }))
            .framerateNumerator(framerateNumerator?.applyValue({ args0 -> args0 }))
            .gopBReference(gopBReference?.applyValue({ args0 -> args0 }))
            .gopClosedCadence(gopClosedCadence?.applyValue({ args0 -> args0 }))
            .gopNumBFrames(gopNumBFrames?.applyValue({ args0 -> args0 }))
            .gopSize(gopSize?.applyValue({ args0 -> args0 }))
            .gopSizeUnits(gopSizeUnits?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0 }))
            .lookAheadRateControl(lookAheadRateControl?.applyValue({ args0 -> args0 }))
            .maxBitrate(maxBitrate?.applyValue({ args0 -> args0 }))
            .minIInterval(minIInterval?.applyValue({ args0 -> args0 }))
            .numRefFrames(numRefFrames?.applyValue({ args0 -> args0 }))
            .parControl(parControl?.applyValue({ args0 -> args0 }))
            .parDenominator(parDenominator?.applyValue({ args0 -> args0 }))
            .parNumerator(parNumerator?.applyValue({ args0 -> args0 }))
            .profile(profile?.applyValue({ args0 -> args0 }))
            .qualityLevel(qualityLevel?.applyValue({ args0 -> args0 }))
            .qvbrQualityLevel(qvbrQualityLevel?.applyValue({ args0 -> args0 }))
            .rateControlMode(rateControlMode?.applyValue({ args0 -> args0 }))
            .scanType(scanType?.applyValue({ args0 -> args0 }))
            .sceneChangeDetect(sceneChangeDetect?.applyValue({ args0 -> args0 }))
            .slices(slices?.applyValue({ args0 -> args0 }))
            .softness(softness?.applyValue({ args0 -> args0 }))
            .spatialAq(spatialAq?.applyValue({ args0 -> args0 }))
            .subgopLength(subgopLength?.applyValue({ args0 -> args0 }))
            .syntax(syntax?.applyValue({ args0 -> args0 }))
            .temporalAq(temporalAq?.applyValue({ args0 -> args0 }))
            .timecodeInsertion(timecodeInsertion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsArgsBuilder internal
constructor() {
    private var adaptiveQuantization: Output<String>? = null

    private var afdSignaling: Output<String>? = null

    private var bitrate: Output<Int>? = null

    private var bufFillPct: Output<Int>? = null

    private var bufSize: Output<Int>? = null

    private var colorMetadata: Output<String>? = null

    private var entropyEncoding: Output<String>? = null

    private var filterSettings:
        Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsFilterSettingsArgs>? =
        null

    private var fixedAfd: Output<String>? = null

    private var flickerAq: Output<String>? = null

    private var forceFieldPictures: Output<String>? = null

    private var framerateControl: Output<String>? = null

    private var framerateDenominator: Output<Int>? = null

    private var framerateNumerator: Output<Int>? = null

    private var gopBReference: Output<String>? = null

    private var gopClosedCadence: Output<Int>? = null

    private var gopNumBFrames: Output<Int>? = null

    private var gopSize: Output<Double>? = null

    private var gopSizeUnits: Output<String>? = null

    private var level: Output<String>? = null

    private var lookAheadRateControl: Output<String>? = null

    private var maxBitrate: Output<Int>? = null

    private var minIInterval: Output<Int>? = null

    private var numRefFrames: Output<Int>? = null

    private var parControl: Output<String>? = null

    private var parDenominator: Output<Int>? = null

    private var parNumerator: Output<Int>? = null

    private var profile: Output<String>? = null

    private var qualityLevel: Output<String>? = null

    private var qvbrQualityLevel: Output<Int>? = null

    private var rateControlMode: Output<String>? = null

    private var scanType: Output<String>? = null

    private var sceneChangeDetect: Output<String>? = null

    private var slices: Output<Int>? = null

    private var softness: Output<Int>? = null

    private var spatialAq: Output<String>? = null

    private var subgopLength: Output<String>? = null

    private var syntax: Output<String>? = null

    private var temporalAq: Output<String>? = null

    private var timecodeInsertion: Output<String>? = null

    /**
     * @param value Enables or disables adaptive quantization.
     */
    @JvmName("vhyssdwelidilnew")
    public suspend fun adaptiveQuantization(`value`: Output<String>) {
        this.adaptiveQuantization = value
    }

    /**
     * @param value Indicates that AFD values will be written into the output stream.
     */
    @JvmName("gmbphooxfxiijlhc")
    public suspend fun afdSignaling(`value`: Output<String>) {
        this.afdSignaling = value
    }

    /**
     * @param value Average bitrate in bits/second.
     */
    @JvmName("vnnepfwgitskvjcb")
    public suspend fun bitrate(`value`: Output<Int>) {
        this.bitrate = value
    }

    /**
     * @param value
     */
    @JvmName("burosopfjiuctfha")
    public suspend fun bufFillPct(`value`: Output<Int>) {
        this.bufFillPct = value
    }

    /**
     * @param value Size of buffer in bits.
     */
    @JvmName("kmlsstnmysmheudh")
    public suspend fun bufSize(`value`: Output<Int>) {
        this.bufSize = value
    }

    /**
     * @param value Includes color space metadata in the output.
     */
    @JvmName("bucrpsjlkxwggcap")
    public suspend fun colorMetadata(`value`: Output<String>) {
        this.colorMetadata = value
    }

    /**
     * @param value Entropy encoding mode.
     */
    @JvmName("penmhdphtedhjlew")
    public suspend fun entropyEncoding(`value`: Output<String>) {
        this.entropyEncoding = value
    }

    /**
     * @param value Filters to apply to an encode. See H265 Filter Settings for more details.
     */
    @JvmName("tdovotrubcajgqxq")
    public suspend
    fun filterSettings(`value`: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsFilterSettingsArgs>) {
        this.filterSettings = value
    }

    /**
     * @param value Four bit AFD value to write on all frames of video in the output stream.
     */
    @JvmName("ftnvoaarrmbrttua")
    public suspend fun fixedAfd(`value`: Output<String>) {
        this.fixedAfd = value
    }

    /**
     * @param value
     */
    @JvmName("ugrmgoushghvoymv")
    public suspend fun flickerAq(`value`: Output<String>) {
        this.flickerAq = value
    }

    /**
     * @param value Controls whether coding is performed on a field basis or on a frame basis.
     */
    @JvmName("xpcukpibsobbwjte")
    public suspend fun forceFieldPictures(`value`: Output<String>) {
        this.forceFieldPictures = value
    }

    /**
     * @param value Indicates how the output video frame rate is specified.
     */
    @JvmName("sewrqrlhrxggyhdk")
    public suspend fun framerateControl(`value`: Output<String>) {
        this.framerateControl = value
    }

    /**
     * @param value Framerate denominator.
     */
    @JvmName("tivpphgtrfykqvjh")
    public suspend fun framerateDenominator(`value`: Output<Int>) {
        this.framerateDenominator = value
    }

    /**
     * @param value Framerate numerator.
     */
    @JvmName("ltmelyloyngteukg")
    public suspend fun framerateNumerator(`value`: Output<Int>) {
        this.framerateNumerator = value
    }

    /**
     * @param value GOP-B reference.
     */
    @JvmName("nhmdupglgnpdqqjh")
    public suspend fun gopBReference(`value`: Output<String>) {
        this.gopBReference = value
    }

    /**
     * @param value Frequency of closed GOPs.
     */
    @JvmName("hleitkgcrmelsbtl")
    public suspend fun gopClosedCadence(`value`: Output<Int>) {
        this.gopClosedCadence = value
    }

    /**
     * @param value Number of B-frames between reference frames.
     */
    @JvmName("vepbxobxirggpmly")
    public suspend fun gopNumBFrames(`value`: Output<Int>) {
        this.gopNumBFrames = value
    }

    /**
     * @param value GOP size in units of either frames of seconds per `gop_size_units`.
     */
    @JvmName("bokkhdrkrbcdmexm")
    public suspend fun gopSize(`value`: Output<Double>) {
        this.gopSize = value
    }

    /**
     * @param value Indicates if the `gop_size` is specified in frames or seconds.
     */
    @JvmName("fwppbpxoounbhcrm")
    public suspend fun gopSizeUnits(`value`: Output<String>) {
        this.gopSizeUnits = value
    }

    /**
     * @param value H265 level.
     */
    @JvmName("kqiwrrocsvtribex")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value Amount of lookahead.
     */
    @JvmName("kohlhlgadyiyujlc")
    public suspend fun lookAheadRateControl(`value`: Output<String>) {
        this.lookAheadRateControl = value
    }

    /**
     * @param value Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
     */
    @JvmName("hottavjdbxasrrvl")
    public suspend fun maxBitrate(`value`: Output<Int>) {
        this.maxBitrate = value
    }

    /**
     * @param value
     */
    @JvmName("dsyaypgfilijjbej")
    public suspend fun minIInterval(`value`: Output<Int>) {
        this.minIInterval = value
    }

    /**
     * @param value Number of reference frames to use.
     */
    @JvmName("crjglolsbuafxjqy")
    public suspend fun numRefFrames(`value`: Output<Int>) {
        this.numRefFrames = value
    }

    /**
     * @param value Indicates how the output pixel aspect ratio is specified.
     */
    @JvmName("bfpgsrgtbmftsvgx")
    public suspend fun parControl(`value`: Output<String>) {
        this.parControl = value
    }

    /**
     * @param value Pixel Aspect Ratio denominator.
     */
    @JvmName("slelhxleicugqrbd")
    public suspend fun parDenominator(`value`: Output<Int>) {
        this.parDenominator = value
    }

    /**
     * @param value Pixel Aspect Ratio numerator.
     */
    @JvmName("mxbjaetiaxsmpspg")
    public suspend fun parNumerator(`value`: Output<Int>) {
        this.parNumerator = value
    }

    /**
     * @param value AAC profile.
     */
    @JvmName("ltftqbodycyfbptb")
    public suspend fun profile(`value`: Output<String>) {
        this.profile = value
    }

    /**
     * @param value Quality level.
     */
    @JvmName("hfhpuyqtkwegppku")
    public suspend fun qualityLevel(`value`: Output<String>) {
        this.qualityLevel = value
    }

    /**
     * @param value Controls the target quality for the video encode.
     */
    @JvmName("bscjhabolrvimcgg")
    public suspend fun qvbrQualityLevel(`value`: Output<Int>) {
        this.qvbrQualityLevel = value
    }

    /**
     * @param value The rate control mode.
     */
    @JvmName("httqawovahkdecmg")
    public suspend fun rateControlMode(`value`: Output<String>) {
        this.rateControlMode = value
    }

    /**
     * @param value Sets the scan type of the output.
     */
    @JvmName("qefmnqlkigtfqjlv")
    public suspend fun scanType(`value`: Output<String>) {
        this.scanType = value
    }

    /**
     * @param value Scene change detection.
     */
    @JvmName("wfjrxnnvntqlyhey")
    public suspend fun sceneChangeDetect(`value`: Output<String>) {
        this.sceneChangeDetect = value
    }

    /**
     * @param value Number of slices per picture.
     */
    @JvmName("bpxibbyoyofsngjs")
    public suspend fun slices(`value`: Output<Int>) {
        this.slices = value
    }

    /**
     * @param value Softness.
     */
    @JvmName("nyxiqveqjhbkufbt")
    public suspend fun softness(`value`: Output<Int>) {
        this.softness = value
    }

    /**
     * @param value Makes adjustments within each frame based on spatial variation of content complexity.
     */
    @JvmName("bnfmqpenbupnhcbs")
    public suspend fun spatialAq(`value`: Output<String>) {
        this.spatialAq = value
    }

    /**
     * @param value Subgop length.
     */
    @JvmName("fkfanqvrmoihwnok")
    public suspend fun subgopLength(`value`: Output<String>) {
        this.subgopLength = value
    }

    /**
     * @param value Produces a bitstream compliant with SMPTE RP-2027.
     */
    @JvmName("xqalmcbbvjbdixqy")
    public suspend fun syntax(`value`: Output<String>) {
        this.syntax = value
    }

    /**
     * @param value Makes adjustments within each frame based on temporal variation of content complexity.
     */
    @JvmName("qtfoxbsvtyjalorf")
    public suspend fun temporalAq(`value`: Output<String>) {
        this.temporalAq = value
    }

    /**
     * @param value Determines how timecodes should be inserted into the video elementary stream.
     */
    @JvmName("yvfmlptahtxgjwqi")
    public suspend fun timecodeInsertion(`value`: Output<String>) {
        this.timecodeInsertion = value
    }

    /**
     * @param value Enables or disables adaptive quantization.
     */
    @JvmName("nbtlywpmsinbccbu")
    public suspend fun adaptiveQuantization(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adaptiveQuantization = mapped
    }

    /**
     * @param value Indicates that AFD values will be written into the output stream.
     */
    @JvmName("pwtxnpucnyanxbui")
    public suspend fun afdSignaling(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.afdSignaling = mapped
    }

    /**
     * @param value Average bitrate in bits/second.
     */
    @JvmName("qayvvelrhtlrsvca")
    public suspend fun bitrate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    /**
     * @param value
     */
    @JvmName("nhhxbjpottrhfthb")
    public suspend fun bufFillPct(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufFillPct = mapped
    }

    /**
     * @param value Size of buffer in bits.
     */
    @JvmName("muqqjkbynitjswoy")
    public suspend fun bufSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufSize = mapped
    }

    /**
     * @param value Includes color space metadata in the output.
     */
    @JvmName("yqsjykfccsfdjmqv")
    public suspend fun colorMetadata(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.colorMetadata = mapped
    }

    /**
     * @param value Entropy encoding mode.
     */
    @JvmName("flgbxcnltcfjuugf")
    public suspend fun entropyEncoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entropyEncoding = mapped
    }

    /**
     * @param value Filters to apply to an encode. See H265 Filter Settings for more details.
     */
    @JvmName("vfjkpwhnvmiiwwpg")
    public suspend
    fun filterSettings(`value`: ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsFilterSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterSettings = mapped
    }

    /**
     * @param argument Filters to apply to an encode. See H265 Filter Settings for more details.
     */
    @JvmName("mbwckreilsaqobts")
    public suspend
    fun filterSettings(argument: suspend ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsFilterSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsFilterSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.filterSettings = mapped
    }

    /**
     * @param value Four bit AFD value to write on all frames of video in the output stream.
     */
    @JvmName("ohttynmlctowiata")
    public suspend fun fixedAfd(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fixedAfd = mapped
    }

    /**
     * @param value
     */
    @JvmName("vddlgcumqcncqbsk")
    public suspend fun flickerAq(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flickerAq = mapped
    }

    /**
     * @param value Controls whether coding is performed on a field basis or on a frame basis.
     */
    @JvmName("ynahokcesnbhsgxw")
    public suspend fun forceFieldPictures(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceFieldPictures = mapped
    }

    /**
     * @param value Indicates how the output video frame rate is specified.
     */
    @JvmName("scxwwpgqhsnmtsrn")
    public suspend fun framerateControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.framerateControl = mapped
    }

    /**
     * @param value Framerate denominator.
     */
    @JvmName("rlytqfxaaoayutiw")
    public suspend fun framerateDenominator(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.framerateDenominator = mapped
    }

    /**
     * @param value Framerate numerator.
     */
    @JvmName("fcmsefhxlgakvocm")
    public suspend fun framerateNumerator(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.framerateNumerator = mapped
    }

    /**
     * @param value GOP-B reference.
     */
    @JvmName("ubxdijeijymbqusd")
    public suspend fun gopBReference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gopBReference = mapped
    }

    /**
     * @param value Frequency of closed GOPs.
     */
    @JvmName("tryowkcfhymayksk")
    public suspend fun gopClosedCadence(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gopClosedCadence = mapped
    }

    /**
     * @param value Number of B-frames between reference frames.
     */
    @JvmName("cxqftrjemurbissw")
    public suspend fun gopNumBFrames(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gopNumBFrames = mapped
    }

    /**
     * @param value GOP size in units of either frames of seconds per `gop_size_units`.
     */
    @JvmName("dqgtusgvrodacthy")
    public suspend fun gopSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gopSize = mapped
    }

    /**
     * @param value Indicates if the `gop_size` is specified in frames or seconds.
     */
    @JvmName("pooqekdhhgpqktui")
    public suspend fun gopSizeUnits(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gopSizeUnits = mapped
    }

    /**
     * @param value H265 level.
     */
    @JvmName("tijnknrxetoyaquk")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value Amount of lookahead.
     */
    @JvmName("wbpydfthxonwbbxq")
    public suspend fun lookAheadRateControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lookAheadRateControl = mapped
    }

    /**
     * @param value Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
     */
    @JvmName("mfvxvbncjlfbwwfi")
    public suspend fun maxBitrate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBitrate = mapped
    }

    /**
     * @param value
     */
    @JvmName("qbxklirywbfhvgqd")
    public suspend fun minIInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minIInterval = mapped
    }

    /**
     * @param value Number of reference frames to use.
     */
    @JvmName("vinsgkkjrbftuves")
    public suspend fun numRefFrames(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numRefFrames = mapped
    }

    /**
     * @param value Indicates how the output pixel aspect ratio is specified.
     */
    @JvmName("getrwxxsroixqidr")
    public suspend fun parControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parControl = mapped
    }

    /**
     * @param value Pixel Aspect Ratio denominator.
     */
    @JvmName("xywgsmhpmrxuhepg")
    public suspend fun parDenominator(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parDenominator = mapped
    }

    /**
     * @param value Pixel Aspect Ratio numerator.
     */
    @JvmName("cugypjslivlyiejv")
    public suspend fun parNumerator(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parNumerator = mapped
    }

    /**
     * @param value AAC profile.
     */
    @JvmName("tciybyqqikamagob")
    public suspend fun profile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param value Quality level.
     */
    @JvmName("topcdmfqyhhcfsfo")
    public suspend fun qualityLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qualityLevel = mapped
    }

    /**
     * @param value Controls the target quality for the video encode.
     */
    @JvmName("jrsxddefsqniwoau")
    public suspend fun qvbrQualityLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qvbrQualityLevel = mapped
    }

    /**
     * @param value The rate control mode.
     */
    @JvmName("mgcupwkpcsfsitmg")
    public suspend fun rateControlMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateControlMode = mapped
    }

    /**
     * @param value Sets the scan type of the output.
     */
    @JvmName("bhkhpcraylvjrjau")
    public suspend fun scanType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanType = mapped
    }

    /**
     * @param value Scene change detection.
     */
    @JvmName("drjfggfbsoeoqbvw")
    public suspend fun sceneChangeDetect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sceneChangeDetect = mapped
    }

    /**
     * @param value Number of slices per picture.
     */
    @JvmName("aiqpqmbitqwxkwak")
    public suspend fun slices(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slices = mapped
    }

    /**
     * @param value Softness.
     */
    @JvmName("opmiogroojogrkqh")
    public suspend fun softness(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softness = mapped
    }

    /**
     * @param value Makes adjustments within each frame based on spatial variation of content complexity.
     */
    @JvmName("tblggrwmmvrxgsja")
    public suspend fun spatialAq(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spatialAq = mapped
    }

    /**
     * @param value Subgop length.
     */
    @JvmName("xlyhwpagkhvsoepc")
    public suspend fun subgopLength(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subgopLength = mapped
    }

    /**
     * @param value Produces a bitstream compliant with SMPTE RP-2027.
     */
    @JvmName("hsilbjjwhrasefcd")
    public suspend fun syntax(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syntax = mapped
    }

    /**
     * @param value Makes adjustments within each frame based on temporal variation of content complexity.
     */
    @JvmName("wlcohmsmerjovpmh")
    public suspend fun temporalAq(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.temporalAq = mapped
    }

    /**
     * @param value Determines how timecodes should be inserted into the video elementary stream.
     */
    @JvmName("iyqtpratnxobtnys")
    public suspend fun timecodeInsertion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timecodeInsertion = mapped
    }

    internal fun build(): ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsArgs =
        ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsArgs(
            adaptiveQuantization = adaptiveQuantization,
            afdSignaling = afdSignaling,
            bitrate = bitrate,
            bufFillPct = bufFillPct,
            bufSize = bufSize,
            colorMetadata = colorMetadata,
            entropyEncoding = entropyEncoding,
            filterSettings = filterSettings,
            fixedAfd = fixedAfd,
            flickerAq = flickerAq,
            forceFieldPictures = forceFieldPictures,
            framerateControl = framerateControl,
            framerateDenominator = framerateDenominator,
            framerateNumerator = framerateNumerator,
            gopBReference = gopBReference,
            gopClosedCadence = gopClosedCadence,
            gopNumBFrames = gopNumBFrames,
            gopSize = gopSize,
            gopSizeUnits = gopSizeUnits,
            level = level,
            lookAheadRateControl = lookAheadRateControl,
            maxBitrate = maxBitrate,
            minIInterval = minIInterval,
            numRefFrames = numRefFrames,
            parControl = parControl,
            parDenominator = parDenominator,
            parNumerator = parNumerator,
            profile = profile,
            qualityLevel = qualityLevel,
            qvbrQualityLevel = qvbrQualityLevel,
            rateControlMode = rateControlMode,
            scanType = scanType,
            sceneChangeDetect = sceneChangeDetect,
            slices = slices,
            softness = softness,
            spatialAq = spatialAq,
            subgopLength = subgopLength,
            syntax = syntax,
            temporalAq = temporalAq,
            timecodeInsertion = timecodeInsertion,
        )
}
