@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10SettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxCll Sets the MaxCLL value for HDR10.
 * @property maxFall Sets the MaxFALL value for HDR10.
 */
public data class
ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10SettingsArgs(
    public val maxCll: Output<Int>? = null,
    public val maxFall: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10SettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10SettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10SettingsArgs.builder()
            .maxCll(maxCll?.applyValue({ args0 -> args0 }))
            .maxFall(maxFall?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10SettingsArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10SettingsArgsBuilder
internal constructor() {
    private var maxCll: Output<Int>? = null

    private var maxFall: Output<Int>? = null

    /**
     * @param value Sets the MaxCLL value for HDR10.
     */
    @JvmName("gpcdgtnfrevwmrya")
    public suspend fun maxCll(`value`: Output<Int>) {
        this.maxCll = value
    }

    /**
     * @param value Sets the MaxFALL value for HDR10.
     */
    @JvmName("ylgkpdhsiojfmncy")
    public suspend fun maxFall(`value`: Output<Int>) {
        this.maxFall = value
    }

    /**
     * @param value Sets the MaxCLL value for HDR10.
     */
    @JvmName("qqsimsesegsadjuo")
    public suspend fun maxCll(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCll = mapped
    }

    /**
     * @param value Sets the MaxFALL value for HDR10.
     */
    @JvmName("wlrkcydvdftmvsxk")
    public suspend fun maxFall(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxFall = mapped
    }

    internal fun build():
        ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10SettingsArgs =
        ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10SettingsArgs(
            maxCll = maxCll,
            maxFall = maxFall,
        )
}
