@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsTimecodeBurninSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property prefix Set a prefix on the burned in timecode.
 * @property timecodeBurninFontSize Sets the size of the burned in timecode.
 * @property timecodeBurninPosition Sets the position of the burned in timecode.
 */
public data class
ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsTimecodeBurninSettingsArgs(
    public val prefix: Output<String>? = null,
    public val timecodeBurninFontSize: Output<String>? = null,
    public val timecodeBurninPosition: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsTimecodeBurninSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsTimecodeBurninSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsTimecodeBurninSettingsArgs.builder()
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .timecodeBurninFontSize(timecodeBurninFontSize?.applyValue({ args0 -> args0 }))
            .timecodeBurninPosition(timecodeBurninPosition?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsTimecodeBurninSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsTimecodeBurninSettingsArgsBuilder
internal constructor() {
    private var prefix: Output<String>? = null

    private var timecodeBurninFontSize: Output<String>? = null

    private var timecodeBurninPosition: Output<String>? = null

    /**
     * @param value Set a prefix on the burned in timecode.
     */
    @JvmName("fkovnapxxedviaos")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Sets the size of the burned in timecode.
     */
    @JvmName("pwvxahrsdrhyppuv")
    public suspend fun timecodeBurninFontSize(`value`: Output<String>) {
        this.timecodeBurninFontSize = value
    }

    /**
     * @param value Sets the position of the burned in timecode.
     */
    @JvmName("sojnokoovgktakts")
    public suspend fun timecodeBurninPosition(`value`: Output<String>) {
        this.timecodeBurninPosition = value
    }

    /**
     * @param value Set a prefix on the burned in timecode.
     */
    @JvmName("xnsqqvferukufuje")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Sets the size of the burned in timecode.
     */
    @JvmName("ffwqavyavlrunhqo")
    public suspend fun timecodeBurninFontSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timecodeBurninFontSize = mapped
    }

    /**
     * @param value Sets the position of the burned in timecode.
     */
    @JvmName("vwxebwufhwadbniy")
    public suspend fun timecodeBurninPosition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timecodeBurninPosition = mapped
    }

    internal fun build():
        ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsTimecodeBurninSettingsArgs =
        ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsTimecodeBurninSettingsArgs(
            prefix = prefix,
            timecodeBurninFontSize = timecodeBurninFontSize,
            timecodeBurninPosition = timecodeBurninPosition,
        )
}
