@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property automaticInputFailoverSettings User-specified settings for defining what the conditions are for declaring the input unhealthy and failing over to a different input. See Automatic Input Failover Settings for more details.
 * @property inputAttachmentName User-specified name for the attachment.
 * @property inputId The ID of the input.
 * @property inputSettings Settings of an input. See Input Settings for more details.
 */
public data class ChannelInputAttachmentArgs(
    public val automaticInputFailoverSettings:
    Output<ChannelInputAttachmentAutomaticInputFailoverSettingsArgs>? = null,
    public val inputAttachmentName: Output<String>,
    public val inputId: Output<String>,
    public val inputSettings: Output<ChannelInputAttachmentInputSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelInputAttachmentArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentArgs.builder()
            .automaticInputFailoverSettings(
                automaticInputFailoverSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .inputAttachmentName(inputAttachmentName.applyValue({ args0 -> args0 }))
            .inputId(inputId.applyValue({ args0 -> args0 }))
            .inputSettings(inputSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ChannelInputAttachmentArgs].
 */
@PulumiTagMarker
public class ChannelInputAttachmentArgsBuilder internal constructor() {
    private var automaticInputFailoverSettings:
        Output<ChannelInputAttachmentAutomaticInputFailoverSettingsArgs>? = null

    private var inputAttachmentName: Output<String>? = null

    private var inputId: Output<String>? = null

    private var inputSettings: Output<ChannelInputAttachmentInputSettingsArgs>? = null

    /**
     * @param value User-specified settings for defining what the conditions are for declaring the input unhealthy and failing over to a different input. See Automatic Input Failover Settings for more details.
     */
    @JvmName("jmsmuekkhajkpkqw")
    public suspend
    fun automaticInputFailoverSettings(`value`: Output<ChannelInputAttachmentAutomaticInputFailoverSettingsArgs>) {
        this.automaticInputFailoverSettings = value
    }

    /**
     * @param value User-specified name for the attachment.
     */
    @JvmName("vcsowsjwfttebvnj")
    public suspend fun inputAttachmentName(`value`: Output<String>) {
        this.inputAttachmentName = value
    }

    /**
     * @param value The ID of the input.
     */
    @JvmName("efvhoqseejocmbji")
    public suspend fun inputId(`value`: Output<String>) {
        this.inputId = value
    }

    /**
     * @param value Settings of an input. See Input Settings for more details.
     */
    @JvmName("njtuuucoqweyktml")
    public suspend fun inputSettings(`value`: Output<ChannelInputAttachmentInputSettingsArgs>) {
        this.inputSettings = value
    }

    /**
     * @param value User-specified settings for defining what the conditions are for declaring the input unhealthy and failing over to a different input. See Automatic Input Failover Settings for more details.
     */
    @JvmName("bcvmxpnbpiuwtahe")
    public suspend
    fun automaticInputFailoverSettings(`value`: ChannelInputAttachmentAutomaticInputFailoverSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticInputFailoverSettings = mapped
    }

    /**
     * @param argument User-specified settings for defining what the conditions are for declaring the input unhealthy and failing over to a different input. See Automatic Input Failover Settings for more details.
     */
    @JvmName("njcjnfvrwsjauagt")
    public suspend
    fun automaticInputFailoverSettings(argument: suspend ChannelInputAttachmentAutomaticInputFailoverSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelInputAttachmentAutomaticInputFailoverSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.automaticInputFailoverSettings = mapped
    }

    /**
     * @param value User-specified name for the attachment.
     */
    @JvmName("plhsjbrharslnpte")
    public suspend fun inputAttachmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputAttachmentName = mapped
    }

    /**
     * @param value The ID of the input.
     */
    @JvmName("qjbploapcuabyjnu")
    public suspend fun inputId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputId = mapped
    }

    /**
     * @param value Settings of an input. See Input Settings for more details.
     */
    @JvmName("kaocijtqrgqvfkfa")
    public suspend fun inputSettings(`value`: ChannelInputAttachmentInputSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputSettings = mapped
    }

    /**
     * @param argument Settings of an input. See Input Settings for more details.
     */
    @JvmName("elrigcdnswjhxsja")
    public suspend
    fun inputSettings(argument: suspend ChannelInputAttachmentInputSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelInputAttachmentInputSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.inputSettings = mapped
    }

    internal fun build(): ChannelInputAttachmentArgs = ChannelInputAttachmentArgs(
        automaticInputFailoverSettings = automaticInputFailoverSettings,
        inputAttachmentName = inputAttachmentName ?: throw PulumiNullFieldException("inputAttachmentName"),
        inputId = inputId ?: throw PulumiNullFieldException("inputId"),
        inputSettings = inputSettings,
    )
}
