@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsInputLossSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property inputLossThresholdMsec The amount of time (in milliseconds) that no input is detected. After that time, an input failover will occur.
 */
public data class
ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsInputLossSettingsArgs(
    public val inputLossThresholdMsec: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsInputLossSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsInputLossSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsInputLossSettingsArgs.builder()
            .inputLossThresholdMsec(inputLossThresholdMsec?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsInputLossSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsInputLossSettingsArgsBuilder
internal constructor() {
    private var inputLossThresholdMsec: Output<Int>? = null

    /**
     * @param value The amount of time (in milliseconds) that no input is detected. After that time, an input failover will occur.
     */
    @JvmName("sqxewubguurqttqx")
    public suspend fun inputLossThresholdMsec(`value`: Output<Int>) {
        this.inputLossThresholdMsec = value
    }

    /**
     * @param value The amount of time (in milliseconds) that no input is detected. After that time, an input failover will occur.
     */
    @JvmName("yeqhoaqqxrrypacw")
    public suspend fun inputLossThresholdMsec(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputLossThresholdMsec = mapped
    }

    internal fun build():
        ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsInputLossSettingsArgs =
        ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsInputLossSettingsArgs(
            inputLossThresholdMsec = inputLossThresholdMsec,
        )
}
