@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the Channel.
 * The following arguments are optional:
 * @property selectorSettings The audio selector settings. See Audio Selector Settings for more details.
 */
public data class ChannelInputAttachmentInputSettingsAudioSelectorArgs(
    public val name: Output<String>,
    public val selectorSettings:
    Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .selectorSettings(
                selectorSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsAudioSelectorArgs].
 */
@PulumiTagMarker
public class ChannelInputAttachmentInputSettingsAudioSelectorArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var selectorSettings:
        Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsArgs>? = null

    /**
     * @param value Name of the Channel.
     * The following arguments are optional:
     */
    @JvmName("qecrtwxrwtipwyej")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The audio selector settings. See Audio Selector Settings for more details.
     */
    @JvmName("mmcbjoducylvwiiw")
    public suspend
    fun selectorSettings(`value`: Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsArgs>) {
        this.selectorSettings = value
    }

    /**
     * @param value Name of the Channel.
     * The following arguments are optional:
     */
    @JvmName("utvndyuihplodvhn")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The audio selector settings. See Audio Selector Settings for more details.
     */
    @JvmName("nkeaffpptiuyexty")
    public suspend
    fun selectorSettings(`value`: ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectorSettings = mapped
    }

    /**
     * @param argument The audio selector settings. See Audio Selector Settings for more details.
     */
    @JvmName("vcnvmfcvfcggywfp")
    public suspend
    fun selectorSettings(argument: suspend ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.selectorSettings = mapped
    }

    internal fun build(): ChannelInputAttachmentInputSettingsAudioSelectorArgs =
        ChannelInputAttachmentInputSettingsAudioSelectorArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            selectorSettings = selectorSettings,
        )
}
