@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property audioHlsRenditionSelection Audio HLS Rendition Selection. See Audio HLS Rendition Selection for more details.
 * @property audioLanguageSelection Audio Language Selection. See Audio Language Selection for more details.
 * @property audioPidSelection Audio Pid Selection. See Audio PID Selection for more details.
 * @property audioTrackSelection Audio Track Selection. See Audio Track Selection for more details.
 */
public data class ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsArgs(
    public val audioHlsRenditionSelection:
    Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioHlsRenditionSelectionArgs>? =
        null,
    public val audioLanguageSelection:
    Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelectionArgs>? =
        null,
    public val audioPidSelection:
    Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioPidSelectionArgs>? =
        null,
    public val audioTrackSelection:
    Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsArgs.builder()
            .audioHlsRenditionSelection(
                audioHlsRenditionSelection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .audioLanguageSelection(
                audioLanguageSelection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .audioPidSelection(audioPidSelection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .audioTrackSelection(
                audioTrackSelection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsArgs].
 */
@PulumiTagMarker
public class ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsArgsBuilder internal
constructor() {
    private var audioHlsRenditionSelection:
        Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioHlsRenditionSelectionArgs>? =
        null

    private var audioLanguageSelection:
        Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelectionArgs>? =
        null

    private var audioPidSelection:
        Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioPidSelectionArgs>? =
        null

    private var audioTrackSelection:
        Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionArgs>? =
        null

    /**
     * @param value Audio HLS Rendition Selection. See Audio HLS Rendition Selection for more details.
     */
    @JvmName("awbggqyiqfdxspnd")
    public suspend
    fun audioHlsRenditionSelection(`value`: Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioHlsRenditionSelectionArgs>) {
        this.audioHlsRenditionSelection = value
    }

    /**
     * @param value Audio Language Selection. See Audio Language Selection for more details.
     */
    @JvmName("vhvwvaotlsyyhsit")
    public suspend
    fun audioLanguageSelection(`value`: Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelectionArgs>) {
        this.audioLanguageSelection = value
    }

    /**
     * @param value Audio Pid Selection. See Audio PID Selection for more details.
     */
    @JvmName("bknayirptiwomucq")
    public suspend
    fun audioPidSelection(`value`: Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioPidSelectionArgs>) {
        this.audioPidSelection = value
    }

    /**
     * @param value Audio Track Selection. See Audio Track Selection for more details.
     */
    @JvmName("qtgnfgpttvksvacg")
    public suspend
    fun audioTrackSelection(`value`: Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionArgs>) {
        this.audioTrackSelection = value
    }

    /**
     * @param value Audio HLS Rendition Selection. See Audio HLS Rendition Selection for more details.
     */
    @JvmName("snmherhixtqgvoac")
    public suspend
    fun audioHlsRenditionSelection(`value`: ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioHlsRenditionSelectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioHlsRenditionSelection = mapped
    }

    /**
     * @param argument Audio HLS Rendition Selection. See Audio HLS Rendition Selection for more details.
     */
    @JvmName("veyctaoxxhkxoyac")
    public suspend
    fun audioHlsRenditionSelection(argument: suspend ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioHlsRenditionSelectionArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioHlsRenditionSelectionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.audioHlsRenditionSelection = mapped
    }

    /**
     * @param value Audio Language Selection. See Audio Language Selection for more details.
     */
    @JvmName("xjntxdbpuepugkur")
    public suspend
    fun audioLanguageSelection(`value`: ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioLanguageSelection = mapped
    }

    /**
     * @param argument Audio Language Selection. See Audio Language Selection for more details.
     */
    @JvmName("gnfclvhrcxrrmvbr")
    public suspend
    fun audioLanguageSelection(argument: suspend ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelectionArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelectionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.audioLanguageSelection = mapped
    }

    /**
     * @param value Audio Pid Selection. See Audio PID Selection for more details.
     */
    @JvmName("bgcmacelslncufug")
    public suspend
    fun audioPidSelection(`value`: ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioPidSelectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioPidSelection = mapped
    }

    /**
     * @param argument Audio Pid Selection. See Audio PID Selection for more details.
     */
    @JvmName("sivyjsopsonolicc")
    public suspend
    fun audioPidSelection(argument: suspend ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioPidSelectionArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioPidSelectionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.audioPidSelection = mapped
    }

    /**
     * @param value Audio Track Selection. See Audio Track Selection for more details.
     */
    @JvmName("hfxblenjgncthpbs")
    public suspend
    fun audioTrackSelection(`value`: ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioTrackSelection = mapped
    }

    /**
     * @param argument Audio Track Selection. See Audio Track Selection for more details.
     */
    @JvmName("aujuxhmmcaqajfhi")
    public suspend
    fun audioTrackSelection(argument: suspend ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.audioTrackSelection = mapped
    }

    internal fun build(): ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsArgs =
        ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsArgs(
            audioHlsRenditionSelection = audioHlsRenditionSelection,
            audioLanguageSelection = audioLanguageSelection,
            audioPidSelection = audioPidSelection,
            audioTrackSelection = audioTrackSelection,
        )
}
