@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioHlsRenditionSelectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupId Specifies the GROUP-ID in the #EXT-X-MEDIA tag of the target HLS audio rendition.
 * @property name Specifies the NAME in the #EXT-X-MEDIA tag of the target HLS audio rendition.
 */
public data class
ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioHlsRenditionSelectionArgs(
    public val groupId: Output<String>,
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioHlsRenditionSelectionArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioHlsRenditionSelectionArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioHlsRenditionSelectionArgs.builder()
            .groupId(groupId.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioHlsRenditionSelectionArgs].
 */
@PulumiTagMarker
public class
ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioHlsRenditionSelectionArgsBuilder
internal constructor() {
    private var groupId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Specifies the GROUP-ID in the #EXT-X-MEDIA tag of the target HLS audio rendition.
     */
    @JvmName("ouhnviehcdodevgq")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value Specifies the NAME in the #EXT-X-MEDIA tag of the target HLS audio rendition.
     */
    @JvmName("wpdunrtotppcabtv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the GROUP-ID in the #EXT-X-MEDIA tag of the target HLS audio rendition.
     */
    @JvmName("knceafmvhhdhhixg")
    public suspend fun groupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Specifies the NAME in the #EXT-X-MEDIA tag of the target HLS audio rendition.
     */
    @JvmName("rqcklkgwfbimnqqc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build():
        ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioHlsRenditionSelectionArgs =
        ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioHlsRenditionSelectionArgs(
            groupId = groupId ?: throw PulumiNullFieldException("groupId"),
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
