@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property languageCode Selects a specific three-letter language code from within an audio source.
 * @property languageSelectionPolicy When set to “strict”, the transport stream demux strictly identifies audio streams by their language descriptor. If a PMT update occurs such that an audio stream matching the initially selected language is no longer present then mute will be encoded until the language returns. If “loose”, then on a PMT update the demux will choose another audio stream in the program with the same stream type if it can’t find one with the same language.
 */
public data class
ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelectionArgs(
    public val languageCode: Output<String>,
    public val languageSelectionPolicy: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelectionArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelectionArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelectionArgs.builder()
            .languageCode(languageCode.applyValue({ args0 -> args0 }))
            .languageSelectionPolicy(languageSelectionPolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelectionArgs].
 */
@PulumiTagMarker
public class
ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelectionArgsBuilder
internal constructor() {
    private var languageCode: Output<String>? = null

    private var languageSelectionPolicy: Output<String>? = null

    /**
     * @param value Selects a specific three-letter language code from within an audio source.
     */
    @JvmName("hvugsddyfgoyplou")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value When set to “strict”, the transport stream demux strictly identifies audio streams by their language descriptor. If a PMT update occurs such that an audio stream matching the initially selected language is no longer present then mute will be encoded until the language returns. If “loose”, then on a PMT update the demux will choose another audio stream in the program with the same stream type if it can’t find one with the same language.
     */
    @JvmName("kpyxdmreualtrgsw")
    public suspend fun languageSelectionPolicy(`value`: Output<String>) {
        this.languageSelectionPolicy = value
    }

    /**
     * @param value Selects a specific three-letter language code from within an audio source.
     */
    @JvmName("grihhcsdviwsckde")
    public suspend fun languageCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value When set to “strict”, the transport stream demux strictly identifies audio streams by their language descriptor. If a PMT update occurs such that an audio stream matching the initially selected language is no longer present then mute will be encoded until the language returns. If “loose”, then on a PMT update the demux will choose another audio stream in the program with the same stream type if it can’t find one with the same language.
     */
    @JvmName("lmnloerpmrpmyoyn")
    public suspend fun languageSelectionPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageSelectionPolicy = mapped
    }

    internal fun build():
        ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelectionArgs =
        ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelectionArgs(
            languageCode = languageCode ?: throw PulumiNullFieldException("languageCode"),
            languageSelectionPolicy = languageSelectionPolicy,
        )
}
