@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dolbyEDecode Configure decoding options for Dolby E streams - these should be Dolby E frames carried in PCM streams tagged with SMPTE-337. See Dolby E Decode for more details.
 * @property tracks Selects one or more unique audio tracks from within a source. See Audio Tracks for more details.
 */
public data class
ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionArgs(
    public val dolbyEDecode:
    Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionDolbyEDecodeArgs>? =
        null,
    public val tracks:
    Output<List<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionTrackArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionArgs.builder()
            .dolbyEDecode(dolbyEDecode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tracks(
                tracks.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionArgs].
 */
@PulumiTagMarker
public class
ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionArgsBuilder
internal constructor() {
    private var dolbyEDecode:
        Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionDolbyEDecodeArgs>? =
        null

    private var tracks:
        Output<List<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionTrackArgs>>? =
        null

    /**
     * @param value Configure decoding options for Dolby E streams - these should be Dolby E frames carried in PCM streams tagged with SMPTE-337. See Dolby E Decode for more details.
     */
    @JvmName("tkqxbpuyldasuihq")
    public suspend
    fun dolbyEDecode(`value`: Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionDolbyEDecodeArgs>) {
        this.dolbyEDecode = value
    }

    /**
     * @param value Selects one or more unique audio tracks from within a source. See Audio Tracks for more details.
     */
    @JvmName("fhkvcbpuxoiwqjls")
    public suspend
    fun tracks(`value`: Output<List<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionTrackArgs>>) {
        this.tracks = value
    }

    @JvmName("grjkowfgcglpgdja")
    public suspend fun tracks(
        vararg
        values: Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionTrackArgs>,
    ) {
        this.tracks = Output.all(values.asList())
    }

    /**
     * @param values Selects one or more unique audio tracks from within a source. See Audio Tracks for more details.
     */
    @JvmName("ypwolgtenxusnray")
    public suspend
    fun tracks(values: List<Output<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionTrackArgs>>) {
        this.tracks = Output.all(values)
    }

    /**
     * @param value Configure decoding options for Dolby E streams - these should be Dolby E frames carried in PCM streams tagged with SMPTE-337. See Dolby E Decode for more details.
     */
    @JvmName("pmrjfevfmifxmbtn")
    public suspend
    fun dolbyEDecode(`value`: ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionDolbyEDecodeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dolbyEDecode = mapped
    }

    /**
     * @param argument Configure decoding options for Dolby E streams - these should be Dolby E frames carried in PCM streams tagged with SMPTE-337. See Dolby E Decode for more details.
     */
    @JvmName("yawvfybltxewdvla")
    public suspend
    fun dolbyEDecode(argument: suspend ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionDolbyEDecodeArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionDolbyEDecodeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dolbyEDecode = mapped
    }

    /**
     * @param value Selects one or more unique audio tracks from within a source. See Audio Tracks for more details.
     */
    @JvmName("nodtedufvjcmevwo")
    public suspend
    fun tracks(`value`: List<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionTrackArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tracks = mapped
    }

    /**
     * @param argument Selects one or more unique audio tracks from within a source. See Audio Tracks for more details.
     */
    @JvmName("qmmrbuknoedfcffc")
    public suspend
    fun tracks(argument: List<suspend ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionTrackArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionTrackArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tracks = mapped
    }

    /**
     * @param argument Selects one or more unique audio tracks from within a source. See Audio Tracks for more details.
     */
    @JvmName("onrhhsapegfgalkd")
    public suspend fun tracks(
        vararg
        argument: suspend ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionTrackArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionTrackArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tracks = mapped
    }

    /**
     * @param argument Selects one or more unique audio tracks from within a source. See Audio Tracks for more details.
     */
    @JvmName("mmaxcvuydfkckiov")
    public suspend
    fun tracks(argument: suspend ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionTrackArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionTrackArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.tracks = mapped
    }

    /**
     * @param values Selects one or more unique audio tracks from within a source. See Audio Tracks for more details.
     */
    @JvmName("dprokoarimwoqxri")
    public suspend fun tracks(
        vararg
        values: ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionTrackArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tracks = mapped
    }

    internal fun build():
        ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionArgs =
        ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionArgs(
            dolbyEDecode = dolbyEDecode,
            tracks = tracks ?: throw PulumiNullFieldException("tracks"),
        )
}
