@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property languageCode Selects a specific three-letter language code from within an audio source.
 * @property name Name of the Channel.
 * The following arguments are optional:
 * @property selectorSettings The audio selector settings. See Audio Selector Settings for more details.
 */
public data class ChannelInputAttachmentInputSettingsCaptionSelectorArgs(
    public val languageCode: Output<String>? = null,
    public val name: Output<String>,
    public val selectorSettings:
    Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorArgs.builder()
            .languageCode(languageCode?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .selectorSettings(
                selectorSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsCaptionSelectorArgs].
 */
@PulumiTagMarker
public class ChannelInputAttachmentInputSettingsCaptionSelectorArgsBuilder internal constructor() {
    private var languageCode: Output<String>? = null

    private var name: Output<String>? = null

    private var selectorSettings:
        Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs>? = null

    /**
     * @param value Selects a specific three-letter language code from within an audio source.
     */
    @JvmName("wexckwnpkliislvc")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value Name of the Channel.
     * The following arguments are optional:
     */
    @JvmName("cvskqsurkvlgsrfr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The audio selector settings. See Audio Selector Settings for more details.
     */
    @JvmName("alwxjxvgrsploicc")
    public suspend
    fun selectorSettings(`value`: Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs>) {
        this.selectorSettings = value
    }

    /**
     * @param value Selects a specific three-letter language code from within an audio source.
     */
    @JvmName("plomjknmyfnauado")
    public suspend fun languageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value Name of the Channel.
     * The following arguments are optional:
     */
    @JvmName("wrgikqtenktmuary")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The audio selector settings. See Audio Selector Settings for more details.
     */
    @JvmName("vhfknomauuuuathn")
    public suspend
    fun selectorSettings(`value`: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectorSettings = mapped
    }

    /**
     * @param argument The audio selector settings. See Audio Selector Settings for more details.
     */
    @JvmName("gmxiuqrsrqnyktbj")
    public suspend
    fun selectorSettings(argument: suspend ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.selectorSettings = mapped
    }

    internal fun build(): ChannelInputAttachmentInputSettingsCaptionSelectorArgs =
        ChannelInputAttachmentInputSettingsCaptionSelectorArgs(
            languageCode = languageCode,
            name = name ?: throw PulumiNullFieldException("name"),
            selectorSettings = selectorSettings,
        )
}
