@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property ancillarySourceSettings Ancillary Source Settings. See Ancillary Source Settings for more details.
 * @property aribSourceSettings ARIB Source Settings.
 * @property dvbSubSourceSettings DVB Sub Source Settings. See DVB Sub Source Settings for more details.
 * @property embeddedSourceSettings Embedded Source Settings. See Embedded Source Settings for more details.
 * @property scte20SourceSettings SCTE20 Source Settings. See SCTE 20 Source Settings for more details.
 * @property scte27SourceSettings SCTE27 Source Settings. See SCTE 27 Source Settings for more details.
 * @property teletextSourceSettings Teletext Source Settings. See Teletext Source Settings for more details.
 */
public data class ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs(
    public val ancillarySourceSettings:
    Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAncillarySourceSettingsArgs>? =
        null,
    public val aribSourceSettings:
    Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAribSourceSettingsArgs>? =
        null,
    public val dvbSubSourceSettings:
    Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsDvbSubSourceSettingsArgs>? =
        null,
    public val embeddedSourceSettings:
    Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettingsArgs>? =
        null,
    public val scte20SourceSettings:
    Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettingsArgs>? =
        null,
    public val scte27SourceSettings:
    Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettingsArgs>? =
        null,
    public val teletextSourceSettings:
    Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs.builder()
            .ancillarySourceSettings(
                ancillarySourceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .aribSourceSettings(
                aribSourceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dvbSubSourceSettings(
                dvbSubSourceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .embeddedSourceSettings(
                embeddedSourceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .scte20SourceSettings(
                scte20SourceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .scte27SourceSettings(
                scte27SourceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .teletextSourceSettings(
                teletextSourceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs].
 */
@PulumiTagMarker
public class ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgsBuilder internal
constructor() {
    private var ancillarySourceSettings:
        Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAncillarySourceSettingsArgs>? =
        null

    private var aribSourceSettings:
        Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAribSourceSettingsArgs>? =
        null

    private var dvbSubSourceSettings:
        Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsDvbSubSourceSettingsArgs>? =
        null

    private var embeddedSourceSettings:
        Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettingsArgs>? =
        null

    private var scte20SourceSettings:
        Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettingsArgs>? =
        null

    private var scte27SourceSettings:
        Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettingsArgs>? =
        null

    private var teletextSourceSettings:
        Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsArgs>? =
        null

    /**
     * @param value Ancillary Source Settings. See Ancillary Source Settings for more details.
     */
    @JvmName("hegphtxkthoupxyh")
    public suspend
    fun ancillarySourceSettings(`value`: Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAncillarySourceSettingsArgs>) {
        this.ancillarySourceSettings = value
    }

    /**
     * @param value ARIB Source Settings.
     */
    @JvmName("aghhkthceykriwda")
    public suspend
    fun aribSourceSettings(`value`: Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAribSourceSettingsArgs>) {
        this.aribSourceSettings = value
    }

    /**
     * @param value DVB Sub Source Settings. See DVB Sub Source Settings for more details.
     */
    @JvmName("pqqobdpgbeghwhdb")
    public suspend
    fun dvbSubSourceSettings(`value`: Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsDvbSubSourceSettingsArgs>) {
        this.dvbSubSourceSettings = value
    }

    /**
     * @param value Embedded Source Settings. See Embedded Source Settings for more details.
     */
    @JvmName("drgslupcrdqdsqyd")
    public suspend
    fun embeddedSourceSettings(`value`: Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettingsArgs>) {
        this.embeddedSourceSettings = value
    }

    /**
     * @param value SCTE20 Source Settings. See SCTE 20 Source Settings for more details.
     */
    @JvmName("dnybrqayovcmthft")
    public suspend
    fun scte20SourceSettings(`value`: Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettingsArgs>) {
        this.scte20SourceSettings = value
    }

    /**
     * @param value SCTE27 Source Settings. See SCTE 27 Source Settings for more details.
     */
    @JvmName("qlbksxosjytqwbja")
    public suspend
    fun scte27SourceSettings(`value`: Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettingsArgs>) {
        this.scte27SourceSettings = value
    }

    /**
     * @param value Teletext Source Settings. See Teletext Source Settings for more details.
     */
    @JvmName("jvcnovndgymblack")
    public suspend
    fun teletextSourceSettings(`value`: Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsArgs>) {
        this.teletextSourceSettings = value
    }

    /**
     * @param value Ancillary Source Settings. See Ancillary Source Settings for more details.
     */
    @JvmName("dwmbhdjywyjgkchf")
    public suspend
    fun ancillarySourceSettings(`value`: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAncillarySourceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ancillarySourceSettings = mapped
    }

    /**
     * @param argument Ancillary Source Settings. See Ancillary Source Settings for more details.
     */
    @JvmName("tjjirgbxubxfjbwn")
    public suspend
    fun ancillarySourceSettings(argument: suspend ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAncillarySourceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAncillarySourceSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ancillarySourceSettings = mapped
    }

    /**
     * @param value ARIB Source Settings.
     */
    @JvmName("ucfpqopvoobxqxts")
    public suspend
    fun aribSourceSettings(`value`: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAribSourceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aribSourceSettings = mapped
    }

    /**
     * @param argument ARIB Source Settings.
     */
    @JvmName("alcrufnbkfwqkhsf")
    public suspend
    fun aribSourceSettings(argument: suspend ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAribSourceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAribSourceSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.aribSourceSettings = mapped
    }

    /**
     * @param value DVB Sub Source Settings. See DVB Sub Source Settings for more details.
     */
    @JvmName("mroonpajcptuujim")
    public suspend
    fun dvbSubSourceSettings(`value`: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsDvbSubSourceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dvbSubSourceSettings = mapped
    }

    /**
     * @param argument DVB Sub Source Settings. See DVB Sub Source Settings for more details.
     */
    @JvmName("yuhxwqvyfrxdkspt")
    public suspend
    fun dvbSubSourceSettings(argument: suspend ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsDvbSubSourceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsDvbSubSourceSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dvbSubSourceSettings = mapped
    }

    /**
     * @param value Embedded Source Settings. See Embedded Source Settings for more details.
     */
    @JvmName("siyupkwnnakxroel")
    public suspend
    fun embeddedSourceSettings(`value`: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.embeddedSourceSettings = mapped
    }

    /**
     * @param argument Embedded Source Settings. See Embedded Source Settings for more details.
     */
    @JvmName("dgfopvvakmdoclmo")
    public suspend
    fun embeddedSourceSettings(argument: suspend ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.embeddedSourceSettings = mapped
    }

    /**
     * @param value SCTE20 Source Settings. See SCTE 20 Source Settings for more details.
     */
    @JvmName("xxdvimhrkwnxyjhv")
    public suspend
    fun scte20SourceSettings(`value`: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scte20SourceSettings = mapped
    }

    /**
     * @param argument SCTE20 Source Settings. See SCTE 20 Source Settings for more details.
     */
    @JvmName("vkrffmmaxnjchxnu")
    public suspend
    fun scte20SourceSettings(argument: suspend ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.scte20SourceSettings = mapped
    }

    /**
     * @param value SCTE27 Source Settings. See SCTE 27 Source Settings for more details.
     */
    @JvmName("yfoognhiabsnolkj")
    public suspend
    fun scte27SourceSettings(`value`: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scte27SourceSettings = mapped
    }

    /**
     * @param argument SCTE27 Source Settings. See SCTE 27 Source Settings for more details.
     */
    @JvmName("wvsdvictbkpspbrs")
    public suspend
    fun scte27SourceSettings(argument: suspend ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.scte27SourceSettings = mapped
    }

    /**
     * @param value Teletext Source Settings. See Teletext Source Settings for more details.
     */
    @JvmName("xscgahgrmuayedkv")
    public suspend
    fun teletextSourceSettings(`value`: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.teletextSourceSettings = mapped
    }

    /**
     * @param argument Teletext Source Settings. See Teletext Source Settings for more details.
     */
    @JvmName("yypnbuflqvddathk")
    public suspend
    fun teletextSourceSettings(argument: suspend ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.teletextSourceSettings = mapped
    }

    internal fun build(): ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs =
        ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs(
            ancillarySourceSettings = ancillarySourceSettings,
            aribSourceSettings = aribSourceSettings,
            dvbSubSourceSettings = dvbSubSourceSettings,
            embeddedSourceSettings = embeddedSourceSettings,
            scte20SourceSettings = scte20SourceSettings,
            scte27SourceSettings = scte27SourceSettings,
            teletextSourceSettings = teletextSourceSettings,
        )
}
