@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property convert608To708 If upconvert, 608 data is both passed through via the “608 compatibility bytes” fields of the 708 wrapper as well as translated into 708. 708 data present in the source content will be discarded.
 * @property scte20Detection Set to “auto” to handle streams with intermittent and/or non-aligned SCTE-20 and Embedded captions.
 * @property source608ChannelNumber Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.
 */
public data class
ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettingsArgs(
    public val convert608To708: Output<String>? = null,
    public val scte20Detection: Output<String>? = null,
    public val source608ChannelNumber: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettingsArgs.builder()
            .convert608To708(convert608To708?.applyValue({ args0 -> args0 }))
            .scte20Detection(scte20Detection?.applyValue({ args0 -> args0 }))
            .source608ChannelNumber(source608ChannelNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettingsArgsBuilder
internal constructor() {
    private var convert608To708: Output<String>? = null

    private var scte20Detection: Output<String>? = null

    private var source608ChannelNumber: Output<Int>? = null

    /**
     * @param value If upconvert, 608 data is both passed through via the “608 compatibility bytes” fields of the 708 wrapper as well as translated into 708. 708 data present in the source content will be discarded.
     */
    @JvmName("jkwcfrhfxjlapijq")
    public suspend fun convert608To708(`value`: Output<String>) {
        this.convert608To708 = value
    }

    /**
     * @param value Set to “auto” to handle streams with intermittent and/or non-aligned SCTE-20 and Embedded captions.
     */
    @JvmName("bilcxdbbmcqkmadr")
    public suspend fun scte20Detection(`value`: Output<String>) {
        this.scte20Detection = value
    }

    /**
     * @param value Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.
     */
    @JvmName("cmpjpvnyqeqqjenu")
    public suspend fun source608ChannelNumber(`value`: Output<Int>) {
        this.source608ChannelNumber = value
    }

    /**
     * @param value If upconvert, 608 data is both passed through via the “608 compatibility bytes” fields of the 708 wrapper as well as translated into 708. 708 data present in the source content will be discarded.
     */
    @JvmName("owwpvgupamtslura")
    public suspend fun convert608To708(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.convert608To708 = mapped
    }

    /**
     * @param value Set to “auto” to handle streams with intermittent and/or non-aligned SCTE-20 and Embedded captions.
     */
    @JvmName("leavtccthcxalnwh")
    public suspend fun scte20Detection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scte20Detection = mapped
    }

    /**
     * @param value Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.
     */
    @JvmName("qxenqgmjpjwgyrwe")
    public suspend fun source608ChannelNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source608ChannelNumber = mapped
    }

    internal fun build():
        ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettingsArgs =
        ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettingsArgs(
            convert608To708 = convert608To708,
            scte20Detection = scte20Detection,
            source608ChannelNumber = source608ChannelNumber,
        )
}
