@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property convert608To708 If upconvert, 608 data is both passed through via the “608 compatibility bytes” fields of the 708 wrapper as well as translated into 708. 708 data present in the source content will be discarded.
 * @property source608ChannelNumber Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.
 */
public data class
ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettingsArgs(
    public val convert608To708: Output<String>? = null,
    public val source608ChannelNumber: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettingsArgs.builder()
            .convert608To708(convert608To708?.applyValue({ args0 -> args0 }))
            .source608ChannelNumber(source608ChannelNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettingsArgsBuilder
internal constructor() {
    private var convert608To708: Output<String>? = null

    private var source608ChannelNumber: Output<Int>? = null

    /**
     * @param value If upconvert, 608 data is both passed through via the “608 compatibility bytes” fields of the 708 wrapper as well as translated into 708. 708 data present in the source content will be discarded.
     */
    @JvmName("rabvdpgkfanihfwr")
    public suspend fun convert608To708(`value`: Output<String>) {
        this.convert608To708 = value
    }

    /**
     * @param value Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.
     */
    @JvmName("osrjbkulkrhdtsaw")
    public suspend fun source608ChannelNumber(`value`: Output<Int>) {
        this.source608ChannelNumber = value
    }

    /**
     * @param value If upconvert, 608 data is both passed through via the “608 compatibility bytes” fields of the 708 wrapper as well as translated into 708. 708 data present in the source content will be discarded.
     */
    @JvmName("wgtlpjdyboicphjd")
    public suspend fun convert608To708(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.convert608To708 = mapped
    }

    /**
     * @param value Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.
     */
    @JvmName("yogbmblvuhndwfed")
    public suspend fun source608ChannelNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source608ChannelNumber = mapped
    }

    internal fun build():
        ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettingsArgs =
        ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettingsArgs(
            convert608To708 = convert608To708,
            source608ChannelNumber = source608ChannelNumber,
        )
}
