@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ocrLanguage If you will configure a WebVTT caption description that references this caption selector, use this field to provide the language to consider when translating the image-based source to text.
 * @property pid Selects a specific PID from within a source.
 */
public data class
ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettingsArgs(
    public val ocrLanguage: Output<String>? = null,
    public val pid: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettingsArgs.builder()
            .ocrLanguage(ocrLanguage?.applyValue({ args0 -> args0 }))
            .pid(pid?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettingsArgsBuilder
internal constructor() {
    private var ocrLanguage: Output<String>? = null

    private var pid: Output<Int>? = null

    /**
     * @param value If you will configure a WebVTT caption description that references this caption selector, use this field to provide the language to consider when translating the image-based source to text.
     */
    @JvmName("vcgvqfswokjijvps")
    public suspend fun ocrLanguage(`value`: Output<String>) {
        this.ocrLanguage = value
    }

    /**
     * @param value Selects a specific PID from within a source.
     */
    @JvmName("ccxgcyaovahiwejt")
    public suspend fun pid(`value`: Output<Int>) {
        this.pid = value
    }

    /**
     * @param value If you will configure a WebVTT caption description that references this caption selector, use this field to provide the language to consider when translating the image-based source to text.
     */
    @JvmName("hlqeorviqtxpitnv")
    public suspend fun ocrLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ocrLanguage = mapped
    }

    /**
     * @param value Selects a specific PID from within a source.
     */
    @JvmName("vugconaabkdkcgwm")
    public suspend fun pid(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pid = mapped
    }

    internal fun build():
        ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettingsArgs =
        ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettingsArgs(
            ocrLanguage = ocrLanguage,
            pid = pid,
        )
}
