@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property outputRectangle Optionally defines a region where TTML style captions will be displayed. See Caption Rectangle for more details.
 * @property pageNumber Specifies the teletext page number within the data stream from which to extract captions. Range of 0x100 (256) to 0x8FF (2303). Unused for passthrough. Should be specified as a hexadecimal string with no “0x” prefix.
 */
public data class
ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsArgs(
    public val outputRectangle:
    Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsOutputRectangleArgs>? =
        null,
    public val pageNumber: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsArgs.builder()
            .outputRectangle(outputRectangle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .pageNumber(pageNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsArgsBuilder
internal constructor() {
    private var outputRectangle:
        Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsOutputRectangleArgs>? =
        null

    private var pageNumber: Output<String>? = null

    /**
     * @param value Optionally defines a region where TTML style captions will be displayed. See Caption Rectangle for more details.
     */
    @JvmName("vtlqlxerxliutqfc")
    public suspend
    fun outputRectangle(`value`: Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsOutputRectangleArgs>) {
        this.outputRectangle = value
    }

    /**
     * @param value Specifies the teletext page number within the data stream from which to extract captions. Range of 0x100 (256) to 0x8FF (2303). Unused for passthrough. Should be specified as a hexadecimal string with no “0x” prefix.
     */
    @JvmName("orknqfllofkfmuuv")
    public suspend fun pageNumber(`value`: Output<String>) {
        this.pageNumber = value
    }

    /**
     * @param value Optionally defines a region where TTML style captions will be displayed. See Caption Rectangle for more details.
     */
    @JvmName("qpieyhbbsjgfikgn")
    public suspend
    fun outputRectangle(`value`: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsOutputRectangleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputRectangle = mapped
    }

    /**
     * @param argument Optionally defines a region where TTML style captions will be displayed. See Caption Rectangle for more details.
     */
    @JvmName("hwowfsoxaasvjuyd")
    public suspend
    fun outputRectangle(argument: suspend ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsOutputRectangleArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsOutputRectangleArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.outputRectangle = mapped
    }

    /**
     * @param value Specifies the teletext page number within the data stream from which to extract captions. Range of 0x100 (256) to 0x8FF (2303). Unused for passthrough. Should be specified as a hexadecimal string with no “0x” prefix.
     */
    @JvmName("jadtgywbmohcmssh")
    public suspend fun pageNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pageNumber = mapped
    }

    internal fun build():
        ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsArgs =
        ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettingsArgs(
            outputRectangle = outputRectangle,
            pageNumber = pageNumber,
        )
}
