@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsNetworkInputSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property hlsInputSettings Specifies HLS input settings when the uri is for a HLS manifest. See HLS Input Settings for more details.
 * @property serverValidation Check HTTPS server certificates.
 */
public data class ChannelInputAttachmentInputSettingsNetworkInputSettingsArgs(
    public val hlsInputSettings:
    Output<ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettingsArgs>? = null,
    public val serverValidation: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsNetworkInputSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsNetworkInputSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsNetworkInputSettingsArgs.builder()
            .hlsInputSettings(hlsInputSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serverValidation(serverValidation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsNetworkInputSettingsArgs].
 */
@PulumiTagMarker
public class ChannelInputAttachmentInputSettingsNetworkInputSettingsArgsBuilder internal
constructor() {
    private var hlsInputSettings:
        Output<ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettingsArgs>? = null

    private var serverValidation: Output<String>? = null

    /**
     * @param value Specifies HLS input settings when the uri is for a HLS manifest. See HLS Input Settings for more details.
     */
    @JvmName("vcefbeqcfwwwghng")
    public suspend
    fun hlsInputSettings(`value`: Output<ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettingsArgs>) {
        this.hlsInputSettings = value
    }

    /**
     * @param value Check HTTPS server certificates.
     */
    @JvmName("jrjvcwpdcbplphyd")
    public suspend fun serverValidation(`value`: Output<String>) {
        this.serverValidation = value
    }

    /**
     * @param value Specifies HLS input settings when the uri is for a HLS manifest. See HLS Input Settings for more details.
     */
    @JvmName("batgflvexuxypqqy")
    public suspend
    fun hlsInputSettings(`value`: ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hlsInputSettings = mapped
    }

    /**
     * @param argument Specifies HLS input settings when the uri is for a HLS manifest. See HLS Input Settings for more details.
     */
    @JvmName("trptdtyldqvjfgdr")
    public suspend
    fun hlsInputSettings(argument: suspend ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.hlsInputSettings = mapped
    }

    /**
     * @param value Check HTTPS server certificates.
     */
    @JvmName("dvjukphdaikaxmbj")
    public suspend fun serverValidation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverValidation = mapped
    }

    internal fun build(): ChannelInputAttachmentInputSettingsNetworkInputSettingsArgs =
        ChannelInputAttachmentInputSettingsNetworkInputSettingsArgs(
            hlsInputSettings = hlsInputSettings,
            serverValidation = serverValidation,
        )
}
