@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsVideoSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property colorSpace
 * @property colorSpaceUsage
 */
public data class ChannelInputAttachmentInputSettingsVideoSelectorArgs(
    public val colorSpace: Output<String>? = null,
    public val colorSpaceUsage: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsVideoSelectorArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsVideoSelectorArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsVideoSelectorArgs.builder()
            .colorSpace(colorSpace?.applyValue({ args0 -> args0 }))
            .colorSpaceUsage(colorSpaceUsage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsVideoSelectorArgs].
 */
@PulumiTagMarker
public class ChannelInputAttachmentInputSettingsVideoSelectorArgsBuilder internal constructor() {
    private var colorSpace: Output<String>? = null

    private var colorSpaceUsage: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("mihjraomqstfsydx")
    public suspend fun colorSpace(`value`: Output<String>) {
        this.colorSpace = value
    }

    /**
     * @param value
     */
    @JvmName("jduaxwdufsrgqrsd")
    public suspend fun colorSpaceUsage(`value`: Output<String>) {
        this.colorSpaceUsage = value
    }

    /**
     * @param value
     */
    @JvmName("mhbayquwymvyvbne")
    public suspend fun colorSpace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.colorSpace = mapped
    }

    /**
     * @param value
     */
    @JvmName("xodkkyrrpgojpmas")
    public suspend fun colorSpaceUsage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.colorSpaceUsage = mapped
    }

    internal fun build(): ChannelInputAttachmentInputSettingsVideoSelectorArgs =
        ChannelInputAttachmentInputSettingsVideoSelectorArgs(
            colorSpace = colorSpace,
            colorSpaceUsage = colorSpaceUsage,
        )
}
