@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property codec
 * @property inputResolution
 * @property maximumBitrate
 */
public data class ChannelInputSpecificationArgs(
    public val codec: Output<String>,
    public val inputResolution: Output<String>,
    public val maximumBitrate: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelInputSpecificationArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputSpecificationArgs.builder()
            .codec(codec.applyValue({ args0 -> args0 }))
            .inputResolution(inputResolution.applyValue({ args0 -> args0 }))
            .maximumBitrate(maximumBitrate.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelInputSpecificationArgs].
 */
@PulumiTagMarker
public class ChannelInputSpecificationArgsBuilder internal constructor() {
    private var codec: Output<String>? = null

    private var inputResolution: Output<String>? = null

    private var maximumBitrate: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ipldlleseubkfnms")
    public suspend fun codec(`value`: Output<String>) {
        this.codec = value
    }

    /**
     * @param value
     */
    @JvmName("ugdgunyqyvvgngpx")
    public suspend fun inputResolution(`value`: Output<String>) {
        this.inputResolution = value
    }

    /**
     * @param value
     */
    @JvmName("neeuwunnbsoudsqb")
    public suspend fun maximumBitrate(`value`: Output<String>) {
        this.maximumBitrate = value
    }

    /**
     * @param value
     */
    @JvmName("pqvgbwkosaehpixg")
    public suspend fun codec(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.codec = mapped
    }

    /**
     * @param value
     */
    @JvmName("arbieviouesbxrqs")
    public suspend fun inputResolution(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputResolution = mapped
    }

    /**
     * @param value
     */
    @JvmName("wjewmutjynqtmral")
    public suspend fun maximumBitrate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maximumBitrate = mapped
    }

    internal fun build(): ChannelInputSpecificationArgs = ChannelInputSpecificationArgs(
        codec = codec ?: throw PulumiNullFieldException("codec"),
        inputResolution = inputResolution ?: throw PulumiNullFieldException("inputResolution"),
        maximumBitrate = maximumBitrate ?: throw PulumiNullFieldException("maximumBitrate"),
    )
}
