@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelVpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityZones
 * @property networkInterfaceIds
 * @property publicAddressAllocationIds List of public address allocation ids to associate with ENIs that will be created in Output VPC. Must specify one for SINGLE_PIPELINE, two for STANDARD channels.
 * @property securityGroupIds A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network interfaces. If none are specified then the VPC default security group will be used.
 * @property subnetIds A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must be mapped to two unique availability zones (AZ).
 */
public data class ChannelVpcArgs(
    public val availabilityZones: Output<List<String>>? = null,
    public val networkInterfaceIds: Output<List<String>>? = null,
    public val publicAddressAllocationIds: Output<List<String>>,
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelVpcArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelVpcArgs =
        com.pulumi.aws.medialive.inputs.ChannelVpcArgs.builder()
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .networkInterfaceIds(networkInterfaceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .publicAddressAllocationIds(
                publicAddressAllocationIds.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ChannelVpcArgs].
 */
@PulumiTagMarker
public class ChannelVpcArgsBuilder internal constructor() {
    private var availabilityZones: Output<List<String>>? = null

    private var networkInterfaceIds: Output<List<String>>? = null

    private var publicAddressAllocationIds: Output<List<String>>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("nxrajuladepesnav")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("thcrddgbqjbjuvvi")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("gusnsckprabghksw")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("brxyqhduribdpwdv")
    public suspend fun networkInterfaceIds(`value`: Output<List<String>>) {
        this.networkInterfaceIds = value
    }

    @JvmName("vhstdthdjlxbunsb")
    public suspend fun networkInterfaceIds(vararg values: Output<String>) {
        this.networkInterfaceIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("silpkmiqjtwswhao")
    public suspend fun networkInterfaceIds(values: List<Output<String>>) {
        this.networkInterfaceIds = Output.all(values)
    }

    /**
     * @param value List of public address allocation ids to associate with ENIs that will be created in Output VPC. Must specify one for SINGLE_PIPELINE, two for STANDARD channels.
     */
    @JvmName("nanrvpnoidsmfdtx")
    public suspend fun publicAddressAllocationIds(`value`: Output<List<String>>) {
        this.publicAddressAllocationIds = value
    }

    @JvmName("eekndhkfrvsiljsm")
    public suspend fun publicAddressAllocationIds(vararg values: Output<String>) {
        this.publicAddressAllocationIds = Output.all(values.asList())
    }

    /**
     * @param values List of public address allocation ids to associate with ENIs that will be created in Output VPC. Must specify one for SINGLE_PIPELINE, two for STANDARD channels.
     */
    @JvmName("ittsmanntvfvtgpt")
    public suspend fun publicAddressAllocationIds(values: List<Output<String>>) {
        this.publicAddressAllocationIds = Output.all(values)
    }

    /**
     * @param value A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network interfaces. If none are specified then the VPC default security group will be used.
     */
    @JvmName("uyutmbcyyhbvfemi")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("yvjfxgvvimiomjrx")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network interfaces. If none are specified then the VPC default security group will be used.
     */
    @JvmName("muyrfamvdmrcmlgi")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must be mapped to two unique availability zones (AZ).
     */
    @JvmName("mqeckkcwmxwjemni")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("githmoegvkubypta")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must be mapped to two unique availability zones (AZ).
     */
    @JvmName("mqwjtlqxrxcrrmrj")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("htffyabdkhhsvhxq")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values
     */
    @JvmName("pmllpnnwmmxajjbk")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value
     */
    @JvmName("ujnwhbnnhxtafebh")
    public suspend fun networkInterfaceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("hledvlkvhlfonjls")
    public suspend fun networkInterfaceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaceIds = mapped
    }

    /**
     * @param value List of public address allocation ids to associate with ENIs that will be created in Output VPC. Must specify one for SINGLE_PIPELINE, two for STANDARD channels.
     */
    @JvmName("hokwfpmsitkulbuq")
    public suspend fun publicAddressAllocationIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicAddressAllocationIds = mapped
    }

    /**
     * @param values List of public address allocation ids to associate with ENIs that will be created in Output VPC. Must specify one for SINGLE_PIPELINE, two for STANDARD channels.
     */
    @JvmName("ryccibamoalrawwc")
    public suspend fun publicAddressAllocationIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicAddressAllocationIds = mapped
    }

    /**
     * @param value A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network interfaces. If none are specified then the VPC default security group will be used.
     */
    @JvmName("csruhmovjflygxfe")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network interfaces. If none are specified then the VPC default security group will be used.
     */
    @JvmName("ryspgiojiqsjydfu")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must be mapped to two unique availability zones (AZ).
     */
    @JvmName("euhfesueusmcapvj")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must be mapped to two unique availability zones (AZ).
     */
    @JvmName("fpvhdtnxdsupyjiv")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): ChannelVpcArgs = ChannelVpcArgs(
        availabilityZones = availabilityZones,
        networkInterfaceIds = networkInterfaceIds,
        publicAddressAllocationIds = publicAddressAllocationIds ?: throw
            PulumiNullFieldException("publicAddressAllocationIds"),
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
    )
}
