@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.InputDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property streamName A unique name for the location the RTMP stream is being pushed to.
 */
public data class InputDestinationArgs(
    public val streamName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.InputDestinationArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.InputDestinationArgs =
        com.pulumi.aws.medialive.inputs.InputDestinationArgs.builder()
            .streamName(streamName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InputDestinationArgs].
 */
@PulumiTagMarker
public class InputDestinationArgsBuilder internal constructor() {
    private var streamName: Output<String>? = null

    /**
     * @param value A unique name for the location the RTMP stream is being pushed to.
     */
    @JvmName("bxomohvwonlwjxlw")
    public suspend fun streamName(`value`: Output<String>) {
        this.streamName = value
    }

    /**
     * @param value A unique name for the location the RTMP stream is being pushed to.
     */
    @JvmName("utviuilvewkklvgb")
    public suspend fun streamName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamName = mapped
    }

    internal fun build(): InputDestinationArgs = InputDestinationArgs(
        streamName = streamName ?: throw PulumiNullFieldException("streamName"),
    )
}
