@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.InputMediaConnectFlowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property flowArn The ARN of the MediaConnect Flow
 */
public data class InputMediaConnectFlowArgs(
    public val flowArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.InputMediaConnectFlowArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.InputMediaConnectFlowArgs =
        com.pulumi.aws.medialive.inputs.InputMediaConnectFlowArgs.builder()
            .flowArn(flowArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InputMediaConnectFlowArgs].
 */
@PulumiTagMarker
public class InputMediaConnectFlowArgsBuilder internal constructor() {
    private var flowArn: Output<String>? = null

    /**
     * @param value The ARN of the MediaConnect Flow
     */
    @JvmName("njifkajxjdfavdxu")
    public suspend fun flowArn(`value`: Output<String>) {
        this.flowArn = value
    }

    /**
     * @param value The ARN of the MediaConnect Flow
     */
    @JvmName("imislpmblwlbwmaa")
    public suspend fun flowArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.flowArn = mapped
    }

    internal fun build(): InputMediaConnectFlowArgs = InputMediaConnectFlowArgs(
        flowArn = flowArn ?: throw PulumiNullFieldException("flowArn"),
    )
}
