@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.InputSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property passwordParam The key used to extract the password from EC2 Parameter store.
 * @property url The URL where the stream is pulled from.
 * @property username The username for the input source.
 */
public data class InputSourceArgs(
    public val passwordParam: Output<String>,
    public val url: Output<String>,
    public val username: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.InputSourceArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.InputSourceArgs =
        com.pulumi.aws.medialive.inputs.InputSourceArgs.builder()
            .passwordParam(passwordParam.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InputSourceArgs].
 */
@PulumiTagMarker
public class InputSourceArgsBuilder internal constructor() {
    private var passwordParam: Output<String>? = null

    private var url: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The key used to extract the password from EC2 Parameter store.
     */
    @JvmName("fmkehmktqkdndibq")
    public suspend fun passwordParam(`value`: Output<String>) {
        this.passwordParam = value
    }

    /**
     * @param value The URL where the stream is pulled from.
     */
    @JvmName("lfjunkbffhlodaih")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The username for the input source.
     */
    @JvmName("htpssuihpdnccesf")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The key used to extract the password from EC2 Parameter store.
     */
    @JvmName("ftemltbaxwyqqvju")
    public suspend fun passwordParam(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.passwordParam = mapped
    }

    /**
     * @param value The URL where the stream is pulled from.
     */
    @JvmName("rkvmfxruljbtvpou")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value The username for the input source.
     */
    @JvmName("xbyxxpksgcyupqyq")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): InputSourceArgs = InputSourceArgs(
        passwordParam = passwordParam ?: throw PulumiNullFieldException("passwordParam"),
        url = url ?: throw PulumiNullFieldException("url"),
        username = username ?: throw PulumiNullFieldException("username"),
    )
}
