@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.MultiplexMultiplexSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maximumVideoBufferDelayMilliseconds Maximum video buffer delay.
 * @property transportStreamBitrate Transport stream bit rate.
 * @property transportStreamId Unique ID for each multiplex.
 * @property transportStreamReservedBitrate Transport stream reserved bit rate.
 */
public data class MultiplexMultiplexSettingsArgs(
    public val maximumVideoBufferDelayMilliseconds: Output<Int>? = null,
    public val transportStreamBitrate: Output<Int>,
    public val transportStreamId: Output<Int>,
    public val transportStreamReservedBitrate: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.MultiplexMultiplexSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.MultiplexMultiplexSettingsArgs =
        com.pulumi.aws.medialive.inputs.MultiplexMultiplexSettingsArgs.builder()
            .maximumVideoBufferDelayMilliseconds(
                maximumVideoBufferDelayMilliseconds?.applyValue({ args0 ->
                    args0
                }),
            )
            .transportStreamBitrate(transportStreamBitrate.applyValue({ args0 -> args0 }))
            .transportStreamId(transportStreamId.applyValue({ args0 -> args0 }))
            .transportStreamReservedBitrate(
                transportStreamReservedBitrate?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [MultiplexMultiplexSettingsArgs].
 */
@PulumiTagMarker
public class MultiplexMultiplexSettingsArgsBuilder internal constructor() {
    private var maximumVideoBufferDelayMilliseconds: Output<Int>? = null

    private var transportStreamBitrate: Output<Int>? = null

    private var transportStreamId: Output<Int>? = null

    private var transportStreamReservedBitrate: Output<Int>? = null

    /**
     * @param value Maximum video buffer delay.
     */
    @JvmName("fxglrqhxgdnvnewc")
    public suspend fun maximumVideoBufferDelayMilliseconds(`value`: Output<Int>) {
        this.maximumVideoBufferDelayMilliseconds = value
    }

    /**
     * @param value Transport stream bit rate.
     */
    @JvmName("qgqcvvpweelgddbi")
    public suspend fun transportStreamBitrate(`value`: Output<Int>) {
        this.transportStreamBitrate = value
    }

    /**
     * @param value Unique ID for each multiplex.
     */
    @JvmName("rgsnylhuffluxdfq")
    public suspend fun transportStreamId(`value`: Output<Int>) {
        this.transportStreamId = value
    }

    /**
     * @param value Transport stream reserved bit rate.
     */
    @JvmName("anfduadgycrquvqm")
    public suspend fun transportStreamReservedBitrate(`value`: Output<Int>) {
        this.transportStreamReservedBitrate = value
    }

    /**
     * @param value Maximum video buffer delay.
     */
    @JvmName("kqvcippdqbcyedma")
    public suspend fun maximumVideoBufferDelayMilliseconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumVideoBufferDelayMilliseconds = mapped
    }

    /**
     * @param value Transport stream bit rate.
     */
    @JvmName("bbvcrknuhoobmlvn")
    public suspend fun transportStreamBitrate(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transportStreamBitrate = mapped
    }

    /**
     * @param value Unique ID for each multiplex.
     */
    @JvmName("xsbfwxqemdgpqqif")
    public suspend fun transportStreamId(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transportStreamId = mapped
    }

    /**
     * @param value Transport stream reserved bit rate.
     */
    @JvmName("xasyihvubjaskaym")
    public suspend fun transportStreamReservedBitrate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportStreamReservedBitrate = mapped
    }

    internal fun build(): MultiplexMultiplexSettingsArgs = MultiplexMultiplexSettingsArgs(
        maximumVideoBufferDelayMilliseconds = maximumVideoBufferDelayMilliseconds,
        transportStreamBitrate = transportStreamBitrate ?: throw
            PulumiNullFieldException("transportStreamBitrate"),
        transportStreamId = transportStreamId ?: throw PulumiNullFieldException("transportStreamId"),
        transportStreamReservedBitrate = transportStreamReservedBitrate,
    )
}
