@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsServiceDescriptorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property providerName Unique provider name.
 * @property serviceName Unique service name.
 */
public data class MultiplexProgramMultiplexProgramSettingsServiceDescriptorArgs(
    public val providerName: Output<String>,
    public val serviceName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsServiceDescriptorArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsServiceDescriptorArgs =
        com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsServiceDescriptorArgs.builder()
            .providerName(providerName.applyValue({ args0 -> args0 }))
            .serviceName(serviceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MultiplexProgramMultiplexProgramSettingsServiceDescriptorArgs].
 */
@PulumiTagMarker
public class MultiplexProgramMultiplexProgramSettingsServiceDescriptorArgsBuilder internal
constructor() {
    private var providerName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Unique provider name.
     */
    @JvmName("talnvttyfuejfqgj")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value Unique service name.
     */
    @JvmName("bscsaphsvfernlrn")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Unique provider name.
     */
    @JvmName("mcjibjgewgdrfhal")
    public suspend fun providerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value Unique service name.
     */
    @JvmName("wigkdcgfkwlhrway")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): MultiplexProgramMultiplexProgramSettingsServiceDescriptorArgs =
        MultiplexProgramMultiplexProgramSettingsServiceDescriptorArgs(
            providerName = providerName ?: throw PulumiNullFieldException("providerName"),
            serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        )
}
