@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id User-specified id. Ths is used in an output group or an output.
 * @property mediaPackageSettings Destination settings for a MediaPackage output; one destination for both encoders. See Media Package Settings for more details.
 * @property multiplexSettings Destination settings for a Multiplex output; one destination for both encoders. See Multiplex Settings for more details.
 * @property settings Destination settings for a standard output; one destination for each redundant encoder. See Settings for more details.
 */
public data class ChannelDestination(
    public val id: String,
    public val mediaPackageSettings: List<ChannelDestinationMediaPackageSetting>? = null,
    public val multiplexSettings: ChannelDestinationMultiplexSettings? = null,
    public val settings: List<ChannelDestinationSetting>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelDestination):
            ChannelDestination = ChannelDestination(
            id = javaType.id(),
            mediaPackageSettings = javaType.mediaPackageSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelDestinationMediaPackageSetting.Companion.toKotlin(args0)
                })
            }),
            multiplexSettings = javaType.multiplexSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelDestinationMultiplexSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            settings = javaType.settings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelDestinationSetting.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
