@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property audioNormalizationSettings Advanced audio normalization settings. See Audio Normalization Settings for more details.
 * @property audioSelectorName The name of the audio selector used as the source for this AudioDescription.
 * @property audioType Applies only if audioTypeControl is useConfigured. The values for audioType are defined in ISO-IEC 13818-1.
 * @property audioTypeControl Determined how audio type is determined.
 * @property audioWatermarkSettings Settings to configure one or more solutions that insert audio watermarks in the audio encode. See Audio Watermark Settings for more details.
 * @property codecSettings Audio codec settings. See Audio Codec Settings for more details.
 * @property languageCode Selects a specific three-letter language code from within an audio source.
 * @property languageCodeControl
 * @property name The name of this audio description.
 * @property remixSettings
 * @property streamName Stream name RTMP destinations (URLs of type rtmp://)
 */
public data class ChannelEncoderSettingsAudioDescription(
    public val audioNormalizationSettings:
    ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettings? = null,
    public val audioSelectorName: String,
    public val audioType: String? = null,
    public val audioTypeControl: String? = null,
    public val audioWatermarkSettings: ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettings? =
        null,
    public val codecSettings: ChannelEncoderSettingsAudioDescriptionCodecSettings? = null,
    public val languageCode: String? = null,
    public val languageCodeControl: String? = null,
    public val name: String,
    public val remixSettings: ChannelEncoderSettingsAudioDescriptionRemixSettings? = null,
    public val streamName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsAudioDescription):
            ChannelEncoderSettingsAudioDescription = ChannelEncoderSettingsAudioDescription(
            audioNormalizationSettings = javaType.audioNormalizationSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            audioSelectorName = javaType.audioSelectorName(),
            audioType = javaType.audioType().map({ args0 -> args0 }).orElse(null),
            audioTypeControl = javaType.audioTypeControl().map({ args0 -> args0 }).orElse(null),
            audioWatermarkSettings = javaType.audioWatermarkSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            codecSettings = javaType.codecSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAudioDescriptionCodecSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            languageCode = javaType.languageCode().map({ args0 -> args0 }).orElse(null),
            languageCodeControl = javaType.languageCodeControl().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            remixSettings = javaType.remixSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAudioDescriptionRemixSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            streamName = javaType.streamName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
