@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property algorithm Audio normalization algorithm to use. itu17701 conforms to the CALM Act specification, itu17702 to the EBU R-128 specification.
 * @property algorithmControl Algorithm control for the audio description.
 * @property targetLkfs Target LKFS (loudness) to adjust volume to.
 */
public data class ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettings(
    public val algorithm: String? = null,
    public val algorithmControl: String? = null,
    public val targetLkfs: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettings):
            ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettings =
            ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettings(
                algorithm = javaType.algorithm().map({ args0 -> args0 }).orElse(null),
                algorithmControl = javaType.algorithmControl().map({ args0 -> args0 }).orElse(null),
                targetLkfs = javaType.targetLkfs().map({ args0 -> args0 }).orElse(null),
            )
    }
}
