@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property nielsenCbetSettings Used to insert watermarks of type Nielsen CBET. See Nielsen CBET Settings for more details.
 * @property nielsenDistributionType Distribution types to assign to the watermarks. Options are `PROGRAM_CONTENT` and `FINAL_DISTRIBUTOR`.
 * @property nielsenNaesIiNwSettings Used to insert watermarks of type Nielsen NAES, II (N2) and Nielsen NAES VI (NW). See Nielsen NAES II NW Settings for more details.
 */
public data class
ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettings(
    public val nielsenCbetSettings:
    ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettings? =
        null,
    public val nielsenDistributionType: String? = null,
    public val nielsenNaesIiNwSettings:
    List<ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSetting>? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettings):
            ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettings =
            ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettings(
                nielsenCbetSettings = javaType.nielsenCbetSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                nielsenDistributionType = javaType.nielsenDistributionType().map({ args0 -> args0 }).orElse(null),
                nielsenNaesIiNwSettings = javaType.nielsenNaesIiNwSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSetting.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
