@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property aacSettings Aac Settings. See AAC Settings for more details.
 * @property ac3Settings Ac3 Settings. See AC3 Settings for more details.
 * @property eac3AtmosSettings Eac3 Atmos Settings. See EAC3 Atmos Settings
 * @property eac3Settings Eac3 Settings. See EAC3 Settings
 * @property mp2Settings
 * @property passThroughSettings
 * @property wavSettings
 */
public data class ChannelEncoderSettingsAudioDescriptionCodecSettings(
    public val aacSettings: ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettings? = null,
    public val ac3Settings: ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3Settings? = null,
    public val eac3AtmosSettings:
    ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettings? = null,
    public val eac3Settings: ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3Settings? = null,
    public val mp2Settings: ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2Settings? = null,
    public val passThroughSettings:
    ChannelEncoderSettingsAudioDescriptionCodecSettingsPassThroughSettings? = null,
    public val wavSettings: ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettings? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsAudioDescriptionCodecSettings):
            ChannelEncoderSettingsAudioDescriptionCodecSettings =
            ChannelEncoderSettingsAudioDescriptionCodecSettings(
                aacSettings = javaType.aacSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                ac3Settings = javaType.ac3Settings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3Settings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                eac3AtmosSettings = javaType.eac3AtmosSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                eac3Settings = javaType.eac3Settings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3Settings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                mp2Settings = javaType.mp2Settings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2Settings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                passThroughSettings = javaType.passThroughSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsPassThroughSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                wavSettings = javaType.wavSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
