@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bitrate Average bitrate in bits/second.
 * @property bitstreamMode Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.
 * @property codingMode Mono, Stereo, or 5.1 channel layout.
 * @property dialnorm Sets the dialnorm of the output.
 * @property drcProfile If set to filmStandard, adds dynamic range compression signaling to the output bitstream as defined in the Dolby Digital specification.
 * @property lfeFilter When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
 * @property metadataControl Metadata control.
 */
public data class ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3Settings(
    public val bitrate: Double? = null,
    public val bitstreamMode: String? = null,
    public val codingMode: String? = null,
    public val dialnorm: Int? = null,
    public val drcProfile: String? = null,
    public val lfeFilter: String? = null,
    public val metadataControl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3Settings):
            ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3Settings =
            ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3Settings(
                bitrate = javaType.bitrate().map({ args0 -> args0 }).orElse(null),
                bitstreamMode = javaType.bitstreamMode().map({ args0 -> args0 }).orElse(null),
                codingMode = javaType.codingMode().map({ args0 -> args0 }).orElse(null),
                dialnorm = javaType.dialnorm().map({ args0 -> args0 }).orElse(null),
                drcProfile = javaType.drcProfile().map({ args0 -> args0 }).orElse(null),
                lfeFilter = javaType.lfeFilter().map({ args0 -> args0 }).orElse(null),
                metadataControl = javaType.metadataControl().map({ args0 -> args0 }).orElse(null),
            )
    }
}
