@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bitrate Average bitrate in bits/second.
 * @property codingMode Mono, Stereo, or 5.1 channel layout.
 * @property sampleRate Sample rate in Hz.
 */
public data class ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2Settings(
    public val bitrate: Double? = null,
    public val codingMode: String? = null,
    public val sampleRate: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2Settings):
            ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2Settings =
            ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2Settings(
                bitrate = javaType.bitrate().map({ args0 -> args0 }).orElse(null),
                codingMode = javaType.codingMode().map({ args0 -> args0 }).orElse(null),
                sampleRate = javaType.sampleRate().map({ args0 -> args0 }).orElse(null),
            )
    }
}
