@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property availBlankingImage Blanking image to be used. See Avail Blanking Image for more details.
 * @property state When set to enabled, causes video, audio and captions to be blanked when insertion metadata is added.
 */
public data class ChannelEncoderSettingsAvailBlanking(
    public val availBlankingImage: ChannelEncoderSettingsAvailBlankingAvailBlankingImage? = null,
    public val state: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsAvailBlanking):
            ChannelEncoderSettingsAvailBlanking = ChannelEncoderSettingsAvailBlanking(
            availBlankingImage = javaType.availBlankingImage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAvailBlankingAvailBlankingImage.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
